/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.PlatformUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;

public final class PlatformUtilsDelegate
implements PlatformUtils.Delegate {
    @Override
    @Nullable
    public InputStream getAsset(@Nullable String asset) {
        if (asset == null) {
            return null;
        }
        try {
            return CouchbaseLiteInternal.getContext().getAssets().open(asset);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    @NonNull
    public PlatformUtils.Base64Encoder getEncoder() {
        if (Build.VERSION.SDK_INT < 26) {
            return src -> Base64.encodeToString((byte[])src, (int)0);
        }
        return new PlatformUtils.Base64Encoder(){
            private final Base64.Encoder encoder = java.util.Base64.getEncoder();

            @Override
            @Nullable
            public String encodeToString(@Nullable byte[] src) {
                return src == null ? null : this.encoder.encodeToString(src);
            }
        };
    }

    @Override
    @NonNull
    public PlatformUtils.Base64Decoder getDecoder() {
        if (Build.VERSION.SDK_INT < 26) {
            return src -> {
                try {
                    return Base64.decode((String)src, (int)0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            };
        }
        return new PlatformUtils.Base64Decoder(){
            private final Base64.Decoder decoder = java.util.Base64.getDecoder();

            @Override
            @Nullable
            public byte[] decodeString(@Nullable String src) {
                try {
                    return src == null ? null : this.decoder.decode(src);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        };
    }
}

