/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONUtils {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        @NonNull
        protected synchronized SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdf;
        }
    };

    private JSONUtils() {
    }

    @NonNull
    public static JSONObject toJSON(@NonNull Map<?, ?> map) throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            json.put(entry.getKey().toString(), JSONUtils.toJSON(entry.getValue()));
        }
        return json;
    }

    @NonNull
    public static JSONArray toJSON(@NonNull List<?> list) throws JSONException {
        JSONArray json = new JSONArray();
        for (Object value : list) {
            json.put(JSONUtils.toJSON(value));
        }
        return json;
    }

    @NonNull
    public static String toJSONString(@NonNull Date date) {
        return DATE_FORMAT.get().format(date);
    }

    @Nullable
    public static Object toJSON(@Nullable Object val) throws JSONException {
        if (val instanceof Map) {
            return JSONUtils.toJSON((Map)val);
        }
        if (val instanceof List) {
            return JSONUtils.toJSON((List)val);
        }
        if (val == null) {
            return JSONObject.NULL;
        }
        return val;
    }

    @NonNull
    public static Map<String, Object> fromJSON(@NonNull JSONObject json) throws JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator itr = json.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            result.put(key, JSONUtils.fromJSON(json.get(key)));
        }
        return result;
    }

    @NonNull
    public static List<Object> fromJSON(@NonNull JSONArray json) throws JSONException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            result.add(JSONUtils.fromJSON(json.get(i)));
        }
        return result;
    }

    @Nullable
    private static Object fromJSON(@Nullable Object value) throws JSONException {
        if (value instanceof JSONObject) {
            return JSONUtils.fromJSON((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return JSONUtils.fromJSON((JSONArray)value);
        }
        if (value == JSONObject.NULL) {
            return null;
        }
        return value;
    }

    @Nullable
    public static Date toDate(@Nullable String json) {
        if (json == null) {
            return null;
        }
        try {
            return DATE_FORMAT.get().parse(json);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

