/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import android.support.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtils {
    private FileUtils() {
    }

    @NonNull
    public static File verifyDir(@NonNull String dirPath) {
        Preconditions.assertNotNull(dirPath, "dirPath");
        return FileUtils.verifyDir(new File(dirPath));
    }

    @NonNull
    public static File verifyDir(@NonNull File dir) {
        Preconditions.assertNotNull(dir, "directory");
        IOException err = null;
        try {
            dir = dir.getCanonicalFile();
            if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
                return dir;
            }
        }
        catch (IOException e) {
            err = e;
        }
        throw new IllegalStateException("Cannot create or access directory at " + dir, err);
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static boolean eraseFileOrDir(@NonNull String fileOrDirectory) {
        Preconditions.assertNotNull(fileOrDirectory, "file or directory");
        return FileUtils.eraseFileOrDir(new File(fileOrDirectory));
    }

    public static boolean eraseFileOrDir(@NonNull File fileOrDirectory) {
        Preconditions.assertNotNull(fileOrDirectory, "file or directory");
        return FileUtils.deleteRecursive(fileOrDirectory);
    }

    public static boolean deleteContents(String fileOrDirectory) {
        return FileUtils.deleteContents(fileOrDirectory == null ? null : new File(fileOrDirectory));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public static boolean deleteContents(File fileOrDirectory) {
        if (fileOrDirectory == null || !fileOrDirectory.isDirectory()) {
            return true;
        }
        File[] contents = fileOrDirectory.listFiles();
        if (contents == null) {
            return true;
        }
        boolean succeeded = true;
        for (File file : contents) {
            if (FileUtils.deleteRecursive(file)) continue;
            Log.i(LogDomain.DATABASE, "Failed deleting file: " + file);
            succeeded = false;
        }
        return succeeded;
    }

    public static boolean setPermissionRecursive(@NonNull File fileOrDirectory, boolean readable, boolean writable) {
        File[] files;
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File child : files) {
                FileUtils.setPermissionRecursive(child, readable, writable);
            }
        }
        return fileOrDirectory.setReadable(readable) && fileOrDirectory.setWritable(writable);
    }

    private static boolean deleteRecursive(File fileOrDirectory) {
        return !fileOrDirectory.exists() || FileUtils.deleteContents(fileOrDirectory) && fileOrDirectory.delete();
    }
}

