/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.support;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.ConsoleLogger;
import com.couchbase.lite.Database;
import com.couchbase.lite.FileLogger;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.core.CBLVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.FormatterClosedException;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Log {
    public static final String LOG_HEADER = "[JAVA] ";
    @NonNull
    private static final Map<String, LogDomain> LOGGING_DOMAINS_FROM_C4;
    @NonNull
    private static final Map<LogDomain, String> LOGGING_DOMAINS_TO_C4;
    @NonNull
    private static final Map<Integer, LogLevel> LOG_LEVEL_FROM_C4;
    @NonNull
    private static final Map<LogLevel, Integer> LOG_LEVEL_TO_C4;
    private static final AtomicBoolean WARNED;
    private static final String DEFAULT_MSG = "Unknown error";
    private static volatile Map<String, String> errorMessages;

    private Log() {
    }

    public static void initLogging(@NonNull Map<String, String> errorMessages) {
        Log.initLogging();
        Log.errorMessages = Collections.unmodifiableMap(errorMessages);
        ConsoleLogger logger = Database.log.getConsole();
        logger.setLevel(LogLevel.INFO);
        Log.i(LogDomain.DATABASE, "CBL-ANDROID Initialized: " + CBLVersion.getVersionInfo());
        logger.setLevel(LogLevel.WARNING);
    }

    @VisibleForTesting
    public static void initLogging() {
        C4Log.forceCallbackLevel(Database.log.getConsole().getLevel());
        Log.setC4LogLevel(LogDomain.ALL_DOMAINS, LogLevel.DEBUG);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.DEBUG, domain, null, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.DEBUG, domain, err, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, null, msg, args);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, err, msg, args);
    }

    public static void v(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.VERBOSE, domain, null, msg, new Object[0]);
    }

    public static void v(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.VERBOSE, domain, err, msg, new Object[0]);
    }

    public static void v(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.VERBOSE, domain, null, msg, args);
    }

    public static void v(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.VERBOSE, domain, err, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.INFO, domain, null, msg, new Object[0]);
    }

    public static void info(@NonNull LogDomain domain, @NonNull String msg) {
        Log.i(domain, msg);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.INFO, domain, err, msg, new Object[0]);
    }

    public static void info(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.i(domain, msg, err);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.INFO, domain, null, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.INFO, domain, err, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.WARNING, domain, null, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.WARNING, domain, err, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.WARNING, domain, null, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.WARNING, domain, err, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.ERROR, domain, null, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.ERROR, domain, err, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.ERROR, domain, null, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.ERROR, domain, err, msg, args);
    }

    @NonNull
    public static String lookupStandardMessage(@Nullable String msg) {
        if (msg == null) {
            return DEFAULT_MSG;
        }
        String message = errorMessages == null ? msg : errorMessages.get(msg);
        return message == null ? msg : message;
    }

    @NonNull
    public static String formatStandardMessage(@Nullable String msg, Object ... args) {
        return String.format(Locale.ENGLISH, Log.lookupStandardMessage(msg), args);
    }

    @NonNull
    public static LogLevel getLogLevelForC4Level(int c4Level) {
        LogLevel level = LOG_LEVEL_FROM_C4.get(c4Level);
        return level != null ? level : LogLevel.INFO;
    }

    public static int getC4LevelForLogLevel(@NonNull LogLevel logLevel) {
        Integer c4level = LOG_LEVEL_TO_C4.get((Object)logLevel);
        return c4level != null ? c4level : 2;
    }

    @NonNull
    public static String getC4DomainForLoggingDomain(@NonNull LogDomain domain) {
        String c4Domain = LOGGING_DOMAINS_TO_C4.get((Object)domain);
        return c4Domain != null ? c4Domain : "DB";
    }

    @NonNull
    public static LogDomain getLoggingDomainForC4Domain(@NonNull String c4Domain) {
        LogDomain domain = LOGGING_DOMAINS_FROM_C4.get(c4Domain);
        return domain != null ? domain : LogDomain.DATABASE;
    }

    public static void warn() {
        if (WARNED.getAndSet(true) || Database.log.getFile().getConfig() != null) {
            return;
        }
        Log.w(LogDomain.DATABASE, "Database.log.getFile().getConfig() is now null: logging is disabled.  Log files required for product support are not being generated.");
    }

    private static void setC4LogLevel(@NonNull EnumSet<LogDomain> domains, @NonNull LogLevel level) {
        int c4Level = Log.getC4LevelForLogLevel(level);
        block7: for (LogDomain domain : domains) {
            switch (domain) {
                case DATABASE: {
                    C4Log.setLevels(c4Level, "DB");
                    continue block7;
                }
                case LISTENER: {
                    C4Log.setLevels(c4Level, "Listener");
                    continue block7;
                }
                case QUERY: {
                    C4Log.setLevels(c4Level, "Query", "SQL");
                    continue block7;
                }
                case REPLICATOR: {
                    C4Log.setLevels(c4Level, "Sync", "SyncBusy");
                    continue block7;
                }
                case NETWORK: {
                    C4Log.setLevels(c4Level, "BLIP", "WS", "TLS");
                    continue block7;
                }
            }
            Log.i(LogDomain.DATABASE, "Unexpected log domain: " + (Object)((Object)domain));
        }
    }

    private static void log(@NonNull LogLevel level, @NonNull LogDomain domain, @Nullable Throwable err, @NonNull String msg, Object ... args) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        if (!Log.shouldLog(level)) {
            return;
        }
        if (domain == null) {
            domain = LogDomain.DATABASE;
        }
        String message = Log.lookupStandardMessage(msg);
        if (args != null && args.length > 0) {
            message = Log.formatMessage(message, args);
        }
        if (err != null) {
            StringWriter sw = new StringWriter();
            err.printStackTrace(new PrintWriter(sw));
            message = message + System.lineSeparator() + sw.toString();
        }
        Log.sendToLoggers(level, domain, LOG_HEADER + message);
    }

    private static boolean shouldLog(@NonNull LogLevel logLevel) {
        LogLevel fileLogLevel;
        LogLevel callbackLevel = C4Log.getCallbackLevel();
        return (callbackLevel.compareTo(fileLogLevel = Database.log.getFile().getLevel()) < 0 ? callbackLevel : fileLogLevel).compareTo(logLevel) <= 0;
    }

    @NonNull
    private static String formatMessage(@NonNull String msg, Object ... args) {
        try {
            return String.format(Locale.ENGLISH, msg, args);
        }
        catch (FormatterClosedException | IllegalFormatException runtimeException) {
            return msg;
        }
    }

    private static void sendToLoggers(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String msg) {
        com.couchbase.lite.Log logger;
        block8: {
            logger = Database.log;
            ConsoleLogger consoleLogger = logger.getConsole();
            Exception consoleErr = null;
            try {
                consoleLogger.log(level, domain, msg);
            }
            catch (Exception e) {
                consoleErr = e;
            }
            FileLogger fileLogger = logger.getFile();
            try {
                fileLogger.log(level, domain, msg);
                if (consoleErr != null) {
                    consoleLogger.log(LogLevel.ERROR, LogDomain.DATABASE, consoleErr.toString());
                }
            }
            catch (Exception e) {
                if (consoleErr != null) break block8;
                fileLogger.log(LogLevel.ERROR, LogDomain.DATABASE, e.toString());
            }
        }
        Logger custom = logger.getCustom();
        if (custom != null) {
            try {
                custom.log(level, domain, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put("DB", (Object)LogDomain.DATABASE);
        m.put("SQL", (Object)LogDomain.DATABASE);
        m.put("Zip", (Object)LogDomain.DATABASE);
        m.put("WS", (Object)LogDomain.NETWORK);
        m.put("BLIP", (Object)LogDomain.NETWORK);
        m.put("TLS", (Object)LogDomain.NETWORK);
        m.put("Sync", (Object)LogDomain.REPLICATOR);
        m.put("SyncBusy", (Object)LogDomain.REPLICATOR);
        m.put("Query", (Object)LogDomain.QUERY);
        m.put("Listener", (Object)LogDomain.LISTENER);
        LOGGING_DOMAINS_FROM_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Object)LogDomain.DATABASE, "DB");
        m.put((Object)LogDomain.NETWORK, "WS");
        m.put((Object)LogDomain.REPLICATOR, "Sync");
        m.put((Object)LogDomain.QUERY, "Query");
        m.put((Object)LogDomain.LISTENER, "Listener");
        LOGGING_DOMAINS_TO_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(0, (Object)LogLevel.DEBUG);
        m.put(1, (Object)LogLevel.VERBOSE);
        m.put(2, (Object)LogLevel.INFO);
        m.put(3, (Object)LogLevel.WARNING);
        m.put(4, (Object)LogLevel.ERROR);
        LOG_LEVEL_FROM_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Object)LogLevel.DEBUG, 0);
        m.put((Object)LogLevel.VERBOSE, 1);
        m.put((Object)LogLevel.INFO, 2);
        m.put((Object)LogLevel.WARNING, 3);
        m.put((Object)LogLevel.ERROR, 4);
        LOG_LEVEL_TO_C4 = Collections.unmodifiableMap(m);
        WARNED = new AtomicBoolean(false);
    }
}

