/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.net.http.X509TrustManagerExtensions;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.replicator.AbstractCBLTrustManager;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public final class CBLTrustManager
extends AbstractCBLTrustManager {
    public CBLTrustManager(@Nullable X509Certificate pinnedServerCert, boolean acceptOnlySelfSignedServerCertificate, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) {
        super(pinnedServerCert, acceptOnlySelfSignedServerCertificate, serverCertsListener);
    }

    @Nullable
    public List<X509Certificate> checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable String host) throws CertificateException {
        List<X509Certificate> serverCerts = this.asList(chain);
        this.notifyListener(serverCerts);
        if (this.useCBLTrustManagement()) {
            this.cBLServerTrustCheck(serverCerts, authType);
            return serverCerts;
        }
        Log.d(LogDomain.NETWORK, "Extended trust check: %d, %s, %s", serverCerts.size(), authType, host);
        return new X509TrustManagerExtensions(this.getDefaultTrustManager()).checkServerTrusted(chain, authType, host);
    }
}

