/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.internal.fleece.Encodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;

public class MValue
implements Encodable {
    static final MValue EMPTY = new MValue(null, null){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    @NonNull
    private static Delegate delegate;
    @Nullable
    private FLValue value;
    @Nullable
    private Object nativeObject;

    public static void registerDelegate(@NonNull Delegate delegate) {
        Preconditions.assertNotNull(delegate, "delegate");
        MValue.delegate = delegate;
    }

    @VisibleForTesting
    @NonNull
    public static Delegate getRegisteredDelegate() {
        return Preconditions.assertNotNull(delegate, "delegate");
    }

    public MValue(@Nullable Object obj) {
        this(obj, null);
    }

    public MValue(@Nullable FLValue val) {
        this(null, val);
    }

    private MValue(@Nullable Object obj, @Nullable FLValue val) {
        this.nativeObject = obj;
        this.value = val;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isMutated() {
        return this.value == null;
    }

    @Nullable
    public FLValue getValue() {
        return this.value;
    }

    public void mutate() {
        Preconditions.assertNotNull(this.nativeObject, "Native object");
        this.value = null;
    }

    @Nullable
    public Object asNative(@Nullable MCollection parent) {
        if (this.nativeObject != null || this.value == null) {
            return this.nativeObject;
        }
        AtomicBoolean cacheIt = new AtomicBoolean(false);
        Object obj = this.toNative(this, parent, cacheIt);
        if (cacheIt.get()) {
            this.nativeObject = obj;
        }
        return obj;
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        if (this.isEmpty()) {
            throw new IllegalStateException("MValue is empty.");
        }
        if (this.value != null) {
            enc.writeValue(this.value);
        } else {
            this.encodeNative(enc, this.nativeObject);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeChangeSlot(null);
        }
        finally {
            super.finalize();
        }
    }

    @Nullable
    private Object toNative(@NonNull MValue mv, @Nullable MCollection parent, @NonNull AtomicBoolean cacheIt) {
        return Preconditions.assertNotNull(delegate, "delegate").toNative(mv, parent, cacheIt);
    }

    @Nullable
    private MCollection collectionFromNative(@Nullable Object obj) {
        return Preconditions.assertNotNull(delegate, "delegate").collectionFromNative(obj);
    }

    private void nativeChangeSlot(@Nullable MValue newSlot) {
        MCollection collection = this.collectionFromNative(newSlot);
        if (collection != null) {
            collection.setSlot(newSlot, this);
        }
    }

    private void encodeNative(@NonNull FLEncoder encoder, @Nullable Object object) {
        Preconditions.assertNotNull(delegate, "delegate").encodeNative(encoder, object);
    }

    public static interface Delegate {
        @Nullable
        public Object toNative(@NonNull MValue var1, @Nullable MCollection var2, @NonNull AtomicBoolean var3);

        @Nullable
        public MCollection collectionFromNative(@Nullable Object var1);

        public void encodeNative(@NonNull FLEncoder var1, @Nullable Object var2);
    }
}

