/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FLEncoder
extends C4NativePeer {
    protected final Map<String, Object> arguments = new HashMap<String, Object>();

    @NonNull
    public static FLEncoder getUnmanagedEncoder(long peer) {
        return new UnmanagedFLEncoder(peer);
    }

    @NonNull
    public static FLEncoder getManagedEncoder() {
        return new ManagedFLEncoder(FLEncoder.newFleeceEncoder());
    }

    private FLEncoder(long peer) {
        super(peer);
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("FLEncoder{").append(ClassUtils.objId(this)).append('/').append(super.toString()).append('[');
        boolean first = true;
        for (Map.Entry<String, Object> arg : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append((Object)arg.getKey()).append("=>").append(arg.getValue());
        }
        return buf.append("]}").toString();
    }

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FLEncoder setArg(@NonNull String key, @Nullable Object arg) {
        Map<String, Object> map = this.arguments;
        synchronized (map) {
            this.arguments.put(key, arg);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getArg(@NonNull String key) {
        Map<String, Object> map = this.arguments;
        synchronized (map) {
            return this.arguments.get(key);
        }
    }

    public boolean writeNull() {
        return FLEncoder.writeNull(this.getPeer());
    }

    public boolean writeString(String value) {
        return FLEncoder.writeString(this.getPeer(), value);
    }

    public boolean writeData(byte[] value) {
        return FLEncoder.writeData(this.getPeer(), value);
    }

    public boolean beginDict(long reserve) {
        return FLEncoder.beginDict(this.getPeer(), reserve);
    }

    public boolean endDict() {
        return FLEncoder.endDict(this.getPeer());
    }

    public boolean beginArray(long reserve) {
        return FLEncoder.beginArray(this.getPeer(), reserve);
    }

    public boolean endArray() {
        return FLEncoder.endArray(this.getPeer());
    }

    public boolean writeKey(String slice) {
        return FLEncoder.writeKey(this.getPeer(), slice);
    }

    public boolean writeValue(@Nullable Object value) {
        long peer = this.getPeer();
        if (value == null) {
            return FLEncoder.writeNull(peer);
        }
        if (value instanceof Boolean) {
            return FLEncoder.writeBool(peer, (Boolean)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return FLEncoder.writeInt(peer, ((Integer)value).longValue());
            }
            if (value instanceof Long) {
                return FLEncoder.writeInt(peer, (Long)value);
            }
            if (value instanceof Short) {
                return FLEncoder.writeInt(peer, ((Short)value).longValue());
            }
            if (value instanceof Double) {
                return FLEncoder.writeDouble(peer, (Double)value);
            }
            return FLEncoder.writeFloat(peer, ((Float)value).floatValue());
        }
        if (value instanceof String) {
            return FLEncoder.writeString(peer, (String)value);
        }
        if (value instanceof byte[]) {
            return FLEncoder.writeData(peer, (byte[])value);
        }
        if (value instanceof List) {
            return this.write((List)value);
        }
        if (value instanceof Map) {
            return this.write((Map)value);
        }
        if (value instanceof FLValue) {
            Boolean val = ((FLValue)value).withContent(hdl -> FLEncoder.writeValue(peer, hdl));
            return val != null && val != false;
        }
        if (value instanceof FLDict) {
            Boolean val = ((FLDict)value).withContent(hdl -> FLEncoder.writeValue(peer, hdl));
            return val != null && val != false;
        }
        if (value instanceof FLArray) {
            Boolean val = ((FLArray)value).withContent(hdl -> FLEncoder.writeValue(peer, hdl));
            return val != null && val != false;
        }
        if (value instanceof FLEncodable) {
            ((FLEncodable)value).encodeTo(this);
            return true;
        }
        return false;
    }

    public boolean write(@Nullable Map<String, Object> map) {
        if (map == null) {
            this.beginDict(0L);
        } else {
            this.beginDict(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.writeKey(entry.getKey());
                this.writeValue(entry.getValue());
            }
        }
        return this.endDict();
    }

    public boolean write(@Nullable List<?> list) {
        if (list == null) {
            this.beginArray(0L);
        } else {
            this.beginArray(list.size());
            for (Object item : list) {
                this.writeValue(item);
            }
        }
        return this.endArray();
    }

    public void reset() {
        FLEncoder.reset(this.getPeer());
    }

    @NonNull
    public byte[] finish() throws LiteCoreException {
        return FLEncoder.finish(this.getPeer());
    }

    @NonNull
    public FLSliceResult finish2() throws LiteCoreException {
        return FLSliceResult.getManagedSliceResult(FLEncoder.finish2(this.getPeer()));
    }

    @NonNull
    public FLSliceResult finish2Unmanaged() throws LiteCoreException {
        return FLSliceResult.getUnmanagedSliceResult(FLEncoder.finish2(this.getPeer()));
    }

    static native long newFleeceEncoder();

    static native void free(long var0);

    static native void reset(long var0);

    private static native boolean writeNull(long var0);

    private static native boolean writeBool(long var0, boolean var2);

    private static native boolean writeInt(long var0, long var2);

    private static native boolean writeFloat(long var0, float var2);

    private static native boolean writeDouble(long var0, double var2);

    private static native boolean writeString(long var0, String var2);

    private static native boolean writeData(long var0, byte[] var2);

    private static native boolean writeValue(long var0, long var2);

    private static native boolean beginArray(long var0, long var2);

    private static native boolean endArray(long var0);

    private static native boolean beginDict(long var0, long var2);

    private static native boolean endDict(long var0);

    private static native boolean writeKey(long var0, String var2);

    @NonNull
    private static native byte[] finish(long var0) throws LiteCoreException;

    private static native long finish2(long var0) throws LiteCoreException;

    static class ManagedFLEncoder
    extends FLEncoder {
        ManagedFLEncoder(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, FLEncoder::free);
        }
    }

    static final class UnmanagedFLEncoder
    extends FLEncoder {
        UnmanagedFLEncoder(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.releasePeer(null, peer -> {
                Map map = this.arguments;
                synchronized (map) {
                    this.arguments.clear();
                }
                UnmanagedFLEncoder.reset(peer);
            });
        }
    }
}

