/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLValue;

public abstract class FLArrayIterator
extends C4NativePeer {
    @NonNull
    public static FLArrayIterator getUnmanagedArrayIterator(long peer) {
        return new UnmanagedFLArrayIterator(peer);
    }

    @NonNull
    public static FLArrayIterator getManagedArrayIterator() {
        return new ManagedFLArrayIterator();
    }

    public FLArrayIterator() {
        super(FLArrayIterator.init());
    }

    public FLArrayIterator(long peer) {
        super(peer);
    }

    public void begin(@NonNull FLArray array) {
        long peer = this.getPeer();
        array.withContent(hdl -> {
            FLArrayIterator.begin(hdl, peer);
            return null;
        });
    }

    public boolean next() {
        return FLArrayIterator.next(this.getPeer());
    }

    @Nullable
    public FLValue getValue() {
        long hValue = FLArrayIterator.getValue(this.getPeer());
        return hValue == 0L ? null : new FLValue(hValue);
    }

    @Nullable
    public FLValue getValueAt(int index) {
        long hValue = FLArrayIterator.getValueAt(this.getPeer(), index);
        return hValue == 0L ? null : new FLValue(hValue);
    }

    static native long init();

    static native void free(long var0);

    private static native void begin(long var0, long var2);

    private static native long getValue(long var0);

    private static native long getValueAt(long var0, int var2);

    private static native boolean next(long var0);

    static final class ManagedFLArrayIterator
    extends FLArrayIterator {
        ManagedFLArrayIterator() {
            super(ManagedFLArrayIterator.init());
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, FLArrayIterator::free);
        }
    }

    static final class UnmanagedFLArrayIterator
    extends FLArrayIterator {
        UnmanagedFLArrayIterator(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.releasePeer();
        }
    }
}

