/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Error;
import com.couchbase.lite.internal.support.Log;

public final class C4ReplicatorStatus {
    private final int activityLevel;
    private final long progressUnitsCompleted;
    private final long progressUnitsTotal;
    private final long progressDocumentCount;
    private final int errorDomain;
    private final int errorCode;
    private final int errorInternalInfo;

    public C4ReplicatorStatus(int activityLevel, int errorDomain, int errorCode) {
        this(activityLevel, 0L, 0L, 0L, errorDomain, errorCode, 0);
    }

    public C4ReplicatorStatus(int activityLevel, long progressUnitsCompleted, long progressUnitsTotal, long progressDocumentCount, int errorDomain, int errorCode, int errorInternalInfo) {
        this.activityLevel = activityLevel;
        this.progressUnitsCompleted = progressUnitsCompleted;
        this.progressUnitsTotal = progressUnitsTotal;
        this.progressDocumentCount = progressDocumentCount;
        this.errorDomain = errorDomain;
        this.errorCode = errorCode;
        this.errorInternalInfo = errorInternalInfo;
        if (activityLevel < 0 || activityLevel > 4) {
            Log.w(LogDomain.REPLICATOR, "Unrecognized activity level: " + activityLevel, new Exception());
        }
    }

    @NonNull
    public C4ReplicatorStatus copy() {
        return new C4ReplicatorStatus(this.activityLevel, this.progressUnitsCompleted, this.progressUnitsTotal, this.progressDocumentCount, this.errorDomain, this.errorCode, this.errorInternalInfo);
    }

    public int getActivityLevel() {
        return this.activityLevel;
    }

    public long getProgressUnitsCompleted() {
        return this.progressUnitsCompleted;
    }

    public long getProgressUnitsTotal() {
        return this.progressUnitsTotal;
    }

    public long getProgressDocumentCount() {
        return this.progressDocumentCount;
    }

    public int getErrorDomain() {
        return this.errorDomain;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorInternalInfo() {
        return this.errorInternalInfo;
    }

    @NonNull
    public C4Error getC4Error() {
        return new C4Error(this.errorDomain, this.errorCode, this.errorInternalInfo);
    }

    @NonNull
    public String toString() {
        return "C4ReplicatorStatus{level=" + this.activityLevel + ",completed=" + this.progressUnitsCompleted + ",total=" + this.progressUnitsTotal + ",#docs=" + this.progressDocumentCount + ",domain=" + this.errorDomain + ",code=" + this.errorCode + ",info=" + this.errorInternalInfo + '}';
    }

    public static final class ActivityLevel {
        public static final int STOPPED = 0;
        public static final int OFFLINE = 1;
        public static final int CONNECTING = 2;
        public static final int IDLE = 3;
        public static final int BUSY = 4;

        private ActivityLevel() {
        }
    }
}

