/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import com.couchbase.lite.internal.core.C4Error;

public class C4DocumentEnded {
    @NonNull
    private final String docID;
    @NonNull
    private final String revID;
    private final int flags;
    private final long sequence;
    private final boolean errorIsTransient;
    private final int errorDomain;
    private final int errorCode;
    private final int errorInternalInfo;

    public C4DocumentEnded(@NonNull String docID, @NonNull String revID, int flags, long sequence, int errorDomain, int errorCode, int errorInternalInfo, boolean errorIsTransient) {
        this.docID = docID;
        this.revID = revID;
        this.flags = flags;
        this.sequence = sequence;
        this.errorDomain = errorDomain;
        this.errorCode = errorCode;
        this.errorInternalInfo = errorInternalInfo;
        this.errorIsTransient = errorIsTransient;
    }

    @NonNull
    public String getDocID() {
        return this.docID;
    }

    @NonNull
    public String getRevID() {
        return this.revID;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getSequence() {
        return this.sequence;
    }

    public int getErrorDomain() {
        return this.errorDomain;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorInternalInfo() {
        return this.errorInternalInfo;
    }

    public boolean errorIsTransient() {
        return this.errorIsTransient;
    }

    @NonNull
    public C4Error getC4Error() {
        return new C4Error(this.errorDomain, this.errorCode, this.errorInternalInfo);
    }

    public boolean isConflicted() {
        return this.errorDomain == 1 && this.errorCode == 8;
    }

    @NonNull
    public String toString() {
        return "C4DocumentEnded{id=" + this.docID + ",rev=" + this.revID + ",flags=" + this.flags + ",error=@" + this.errorDomain + "#" + this.errorCode + "(" + this.errorInternalInfo + "):" + this.errorIsTransient + "}";
    }
}

