/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;

public final class C4DatabaseChange {
    @Nullable
    private final String docID;
    @NonNull
    private final String revID;
    private final long sequence;
    private final boolean external;

    @Nullable
    public static C4DatabaseChange createC4DatabaseChange(@Nullable String docId, @Nullable String revId, long seq, boolean ext) {
        if (docId != null && revId != null) {
            return new C4DatabaseChange(docId, revId, seq, ext);
        }
        Log.i(LogDomain.DATABASE, "Bad db change notification: (%s, %s)", docId, revId);
        return null;
    }

    private C4DatabaseChange(@Nullable String docID, @NonNull String revID, long seq, boolean ext) {
        this.docID = docID;
        this.revID = revID;
        this.sequence = seq;
        this.external = ext;
    }

    @Nullable
    public String getDocID() {
        return this.docID;
    }

    @NonNull
    public String getRevID() {
        return this.revID;
    }

    public long getSequence() {
        return this.sequence;
    }

    public boolean isExternal() {
        return this.external;
    }
}

