/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MaintenanceType;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4DatabaseObserver;
import com.couchbase.lite.internal.core.C4DatabaseObserverListener;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4DocumentObserver;
import com.couchbase.lite.internal.core.C4DocumentObserverListener;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4RawDocument;
import com.couchbase.lite.internal.core.C4ReplicationFilter;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4ReplicatorListener;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class C4Database
extends C4NativePeer {
    @VisibleForTesting
    public static final String DB_EXTENSION = ".cblite2";
    @NonNull
    private static final Map<MaintenanceType, Integer> MAINTENANCE_TYPE_MAP;
    final AtomicReference<File> dbFile = new AtomicReference();

    public static void copyDb(@NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        if (sourcePath.charAt(sourcePath.length() - 1) != File.separatorChar) {
            sourcePath = sourcePath + File.separator;
        }
        if (parentDir.charAt(parentDir.length() - 1) != File.separatorChar) {
            parentDir = parentDir + File.separator;
        }
        C4Database.copy(sourcePath, parentDir, name, flags, algorithm, encryptionKey);
    }

    public static void deleteNamedDb(@NonNull String directory, @NonNull String name) throws LiteCoreException {
        C4Database.deleteNamed(name, directory);
    }

    @NonNull
    public static File getDatabaseFile(@NonNull File directory, @NonNull String name) {
        return new File(directory, name + DB_EXTENSION);
    }

    static void rawFreeDocument(long rawDoc) throws LiteCoreException {
        C4Database.rawFree(rawDoc);
    }

    @NonNull
    public static C4Database getUnmanagedDatabase(long peer) {
        return new UnmanagedC4Database(peer);
    }

    @NonNull
    public static C4Database getDatabase(@NonNull String parentDirPath, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        boolean pathOk = false;
        try {
            File parentDir = new File(parentDirPath);
            parentDirPath = parentDir.getCanonicalPath();
            pathOk = parentDir.exists() && parentDir.isDirectory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!pathOk) {
            throw new LiteCoreException(1, 21, "Parent directory does not exist or is not a directory: " + parentDirPath);
        }
        return new ManagedC4Database(C4Database.open(parentDirPath, name, flags, algorithm, encryptionKey));
    }

    protected C4Database(long peer) {
        super(peer);
    }

    @Override
    public abstract void close();

    @Nullable
    public String getDbPath() {
        File file = this.getDbFile();
        return file == null ? null : file.getPath() + File.separator;
    }

    @Nullable
    public String getDbDirectory() {
        File file = this.getDbFile();
        return file == null ? null : file.getParent();
    }

    @Nullable
    public String getDbFileName() {
        File file = this.getDbFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public String getDbName() {
        String dbFileName = this.getDbFileName();
        if (dbFileName == null) {
            return null;
        }
        if (dbFileName.endsWith(DB_EXTENSION)) {
            dbFileName = dbFileName.substring(0, dbFileName.length() - DB_EXTENSION.length());
        }
        return dbFileName;
    }

    public void rekey(int keyType, byte[] newKey) throws LiteCoreException {
        C4Database.rekey(this.getPeer(), keyType, newKey);
    }

    public void closeDb() throws LiteCoreException {
        C4Database.close(this.getPeer());
        this.close();
    }

    public void deleteDb() throws LiteCoreException {
        C4Database.delete(this.getPeer());
        this.close();
    }

    public long getDocumentCount() {
        return C4Database.getDocumentCount(this.getPeer());
    }

    public void purgeDoc(String docID) throws LiteCoreException {
        C4Database.purgeDoc(this.getPeer(), docID);
    }

    @NonNull
    public byte[] getPublicUUID() throws LiteCoreException {
        return C4Database.getPublicUUID(this.getPeer());
    }

    public void beginTransaction() throws LiteCoreException {
        C4Database.beginTransaction(this.getPeer());
    }

    public void endTransaction(boolean commit) throws LiteCoreException {
        C4Database.endTransaction(this.getPeer(), commit);
    }

    @NonNull
    public FLEncoder getSharedFleeceEncoder() {
        return FLEncoder.getUnmanagedEncoder(C4Database.getSharedFleeceEncoder(this.getPeer()));
    }

    @NonNull
    public C4Document get(@NonNull String docID) throws LiteCoreException {
        return new C4Document(this.getPeer(), docID, true);
    }

    public void setExpiration(@NonNull String docID, long timestamp) throws LiteCoreException {
        C4Document.setExpiration(this.getPeer(), docID, timestamp);
    }

    public long getExpiration(@NonNull String docID) throws LiteCoreException {
        return C4Document.getExpiration(this.getPeer(), docID);
    }

    @NonNull
    public C4Document create(@NonNull String docID, @Nullable FLSliceResult body, int flags) throws LiteCoreException {
        return new C4Document(C4Document.create2(this.getPeer(), docID, body != null ? body.getHandle() : 0L, flags));
    }

    @NonNull
    public C4DatabaseObserver createDatabaseObserver(@NonNull Object context, @NonNull C4DatabaseObserverListener listener) {
        return C4DatabaseObserver.newObserver(this.getPeer(), listener, context);
    }

    @NonNull
    public C4DocumentObserver createDocumentObserver(@NonNull String docID, @NonNull Object context, @NonNull C4DocumentObserverListener listener) {
        return C4DocumentObserver.newObserver(this.getPeer(), docID, listener, context);
    }

    @NonNull
    public C4BlobStore getBlobStore() throws LiteCoreException {
        return C4BlobStore.getUnmanagedBlobStore(this.getPeer());
    }

    @NonNull
    public C4Query createJsonQuery(@NonNull String expression) throws LiteCoreException {
        return new C4Query(this.getPeer(), AbstractIndex.QueryLanguage.JSON, expression);
    }

    @NonNull
    public C4Query createN1qlQuery(@NonNull String expression) throws LiteCoreException {
        return new C4Query(this.getPeer(), AbstractIndex.QueryLanguage.N1QL, expression);
    }

    public void createIndex(@NonNull String name, @NonNull String queryExpression, @NonNull AbstractIndex.QueryLanguage queryLanguage, @NonNull AbstractIndex.IndexType indexType, @Nullable String language, boolean ignoreDiacritics) throws LiteCoreException {
        C4Query.createIndex(this, name, queryExpression, queryLanguage, indexType, language, ignoreDiacritics);
    }

    public void deleteIndex(String name) throws LiteCoreException {
        C4Query.deleteIndex(this, name);
    }

    @NonNull
    public FLValue getIndexesInfo() throws LiteCoreException {
        return C4Query.getIndexInfo(this);
    }

    public boolean performMaintenance(MaintenanceType type) throws LiteCoreException {
        return C4Database.maintenance(this.getPeer(), Preconditions.assertNotNull(MAINTENANCE_TYPE_MAP.get((Object)type), "Unrecognized maintenance type: " + (Object)((Object)type)));
    }

    @NonNull
    public C4Replicator createRemoteReplicator(@Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDatabaseName, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext, @Nullable SocketFactory socketFactoryContext, int framing) throws LiteCoreException {
        return C4Replicator.createRemoteReplicator(this.getPeer(), scheme, host, port, path, remoteDatabaseName, push, pull, options, listener, pushFilter, pullFilter, replicatorContext, socketFactoryContext, framing);
    }

    @NonNull
    public C4Replicator createLocalReplicator(@NonNull C4Database otherLocalDB, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext) throws LiteCoreException {
        return C4Replicator.createLocalReplicator(this.getPeer(), otherLocalDB, push, pull, options, listener, pushFilter, pullFilter, replicatorContext);
    }

    @NonNull
    public C4Replicator createTargetReplicator(@NonNull C4Socket openSocket, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @NonNull Object replicatorContext) throws LiteCoreException {
        return C4Replicator.createTargetReplicator(this.getPeer(), openSocket, push, pull, options, listener, replicatorContext);
    }

    public void setCookie(@NonNull URI uri, @NonNull String setCookieHeader) throws LiteCoreException {
        C4Database.setCookie(this.getPeer(), uri.toString(), setCookieHeader);
    }

    @Nullable
    public String getCookies(@NonNull URI uri) throws LiteCoreException {
        return C4Database.getCookies(this.getPeer(), uri.toString());
    }

    @VisibleForTesting
    @NonNull
    public C4Document get(@NonNull String docID, boolean mustExist) throws LiteCoreException {
        return new C4Document(this.getPeer(), docID, mustExist);
    }

    long getHandle() {
        return this.getPeer();
    }

    @NonNull
    FLSharedKeys getFLSharedKeys() {
        return new FLSharedKeys(C4Database.getFLSharedKeys(this.getPeer()));
    }

    @VisibleForTesting
    @NonNull
    C4Document create(@NonNull String docID, @NonNull byte[] body, int revisionFlags) throws LiteCoreException {
        return new C4Document(C4Document.create(this.getPeer(), docID, body, revisionFlags));
    }

    @VisibleForTesting
    void compact() throws LiteCoreException {
        C4Database.maintenance(this.getPeer(), 0);
    }

    @VisibleForTesting
    long getLastSequence() {
        return C4Database.getLastSequence(this.getPeer());
    }

    @NonNull
    @VisibleForTesting
    byte[] getPrivateUUID() throws LiteCoreException {
        return C4Database.getPrivateUUID(this.getPeer());
    }

    @VisibleForTesting
    @NonNull
    FLSliceResult encodeJSON(@NonNull String data) throws LiteCoreException {
        return FLSliceResult.getManagedSliceResult(C4Database.encodeJSON(this.getPeer(), data.getBytes(StandardCharsets.UTF_8)));
    }

    @VisibleForTesting
    @NonNull
    C4Document getBySequence(long sequence) throws LiteCoreException {
        return new C4Document(this.getPeer(), sequence);
    }

    @VisibleForTesting
    @NonNull
    public C4Document put(@NonNull byte[] body, @NonNull String docID, int revFlags, boolean existingRevision, boolean allowConflict, @NonNull String[] history, boolean save, int maxRevTreeDepth, int remoteDBID) throws LiteCoreException {
        return new C4Document(C4Document.put(this.getPeer(), body, docID, revFlags, existingRevision, allowConflict, history, save, maxRevTreeDepth, remoteDBID));
    }

    @NonNull
    @VisibleForTesting
    C4Document put(@NonNull FLSliceResult body, @NonNull String docID, int revFlags, boolean existingRevision, boolean allowConflict, @NonNull String[] history, boolean save, int maxRevTreeDepth, int remoteDBID) throws LiteCoreException {
        return new C4Document(C4Document.put2(this.getPeer(), body.getHandle(), docID, revFlags, existingRevision, allowConflict, history, save, maxRevTreeDepth, remoteDBID));
    }

    @VisibleForTesting
    void rawPut(String storeName, String key, String meta, byte[] body) throws LiteCoreException {
        C4Database.rawPut(this.getPeer(), storeName, key, meta, body);
    }

    @VisibleForTesting
    @NonNull
    C4RawDocument rawGet(@NonNull String storeName, @NonNull String docID) throws LiteCoreException {
        return new C4RawDocument(C4Database.rawGet(this.getPeer(), storeName, docID));
    }

    @Nullable
    private File getDbFile() {
        File file = this.dbFile.get();
        if (file != null) {
            return file;
        }
        String path = C4Database.getPath(this.getPeer());
        if (path == null) {
            return null;
        }
        try {
            this.dbFile.compareAndSet(null, new File(path).getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.dbFile.get();
    }

    static native long open(@NonNull String var0, @NonNull String var1, int var2, int var3, byte[] var4) throws LiteCoreException;

    static native void free(long var0);

    private static native long rawGet(long var0, String var2, String var3) throws LiteCoreException;

    private static native void rawPut(long var0, String var2, String var3, String var4, byte[] var5) throws LiteCoreException;

    private static native void copy(String var0, String var1, String var2, int var3, int var4, byte[] var5) throws LiteCoreException;

    private static native void close(long var0) throws LiteCoreException;

    private static native void delete(long var0) throws LiteCoreException;

    private static native void deleteNamed(@NonNull String var0, @NonNull String var1) throws LiteCoreException;

    private static native void rekey(long var0, int var2, byte[] var3) throws LiteCoreException;

    @Nullable
    private static native String getPath(long var0);

    private static native long getDocumentCount(long var0);

    private static native long getLastSequence(long var0);

    private static native void purgeDoc(long var0, String var2) throws LiteCoreException;

    @NonNull
    private static native byte[] getPublicUUID(long var0) throws LiteCoreException;

    @NonNull
    private static native byte[] getPrivateUUID(long var0) throws LiteCoreException;

    private static native void beginTransaction(long var0) throws LiteCoreException;

    private static native void endTransaction(long var0, boolean var2) throws LiteCoreException;

    private static native void rawFree(long var0) throws LiteCoreException;

    private static native void setCookie(long var0, String var2, String var3) throws LiteCoreException;

    @NonNull
    private static native String getCookies(long var0, @NonNull String var2) throws LiteCoreException;

    private static native long getSharedFleeceEncoder(long var0);

    private static native long encodeJSON(long var0, byte[] var2) throws LiteCoreException;

    private static native long getFLSharedKeys(long var0);

    private static native boolean maintenance(long var0, int var2) throws LiteCoreException;

    static {
        HashMap<MaintenanceType, Integer> m = new HashMap<MaintenanceType, Integer>();
        m.put(MaintenanceType.COMPACT, 0);
        m.put(MaintenanceType.REINDEX, 1);
        m.put(MaintenanceType.INTEGRITY_CHECK, 2);
        m.put(MaintenanceType.OPTIMIZE, 3);
        m.put(MaintenanceType.FULL_OPTIMIZE, 4);
        MAINTENANCE_TYPE_MAP = Collections.unmodifiableMap(m);
    }

    static final class ManagedC4Database
    extends C4Database {
        ManagedC4Database(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, C4Database::free);
        }
    }

    static final class UnmanagedC4Database
    extends C4Database {
        UnmanagedC4Database(long peer) {
            super(peer);
        }

        @Override
        public void close() {
            this.releasePeer();
        }
    }
}

