/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;

public class BaseReplicator
implements AutoCloseable {
    private final Object lock = new Object();
    @Nullable
    private C4Replicator c4Replicator;

    protected BaseReplicator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        C4Replicator c4Repl;
        Object object = this.getReplicatorLock();
        synchronized (object) {
            c4Repl = this.c4Replicator;
            this.c4Replicator = null;
        }
        this.closeC4Replicator(c4Repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public C4Replicator getC4Replicator() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.c4Replicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setC4Replicator(@NonNull C4Replicator c4Repl) {
        Log.d(LogDomain.REPLICATOR, "Setting c4 replicator %s for replicator %s", ClassUtils.objId(c4Repl), ClassUtils.objId(this));
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.c4Replicator = c4Repl;
        }
    }

    @NonNull
    protected Object getReplicatorLock() {
        return this.lock;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.closeC4Replicator(this.getC4Replicator())) {
                Log.i(LogDomain.REPLICATOR, "Replicator was not closed " + ClassUtils.objId(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    private boolean closeC4Replicator(@Nullable C4Replicator c4Repl) {
        if (c4Repl == null) {
            return false;
        }
        c4Repl.close();
        return true;
    }
}

