/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.connectivity;

import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.connectivity.AndroidConnectivityManager;
import com.couchbase.lite.internal.support.Log;
import java.lang.ref.WeakReference;

abstract class ConnectivityWatcher {
    @NonNull
    protected final String name;
    @NonNull
    private final WeakReference<AndroidConnectivityManager> mgr;

    ConnectivityWatcher(@NonNull String name, @NonNull AndroidConnectivityManager mgr) {
        this.name = name;
        this.mgr = new WeakReference<AndroidConnectivityManager>(mgr);
    }

    public abstract void start();

    public abstract boolean isConnected();

    public abstract void stop();

    @Nullable
    protected final AndroidConnectivityManager getCblMgr() {
        return (AndroidConnectivityManager)this.mgr.get();
    }

    @Nullable
    protected final ConnectivityManager getSysMgr() {
        return (ConnectivityManager)CouchbaseLiteInternal.getContext().getSystemService("connectivity");
    }

    protected final void onConnectivityChange(boolean networkState) {
        AndroidConnectivityManager cblConnectivityMgr = this.getCblMgr();
        if (cblConnectivityMgr == null) {
            this.stop();
            return;
        }
        Log.d(LogDomain.NETWORK, "Changed %s connectivity for %s: %s", this.name, this.getCblMgr(), this);
        cblConnectivityMgr.connectivityChanged(networkState);
    }

    protected final void logStart() {
        Log.d(LogDomain.NETWORK, "Started %s network listener for %s: %s", this.name, this.getCblMgr(), this);
    }
}

