/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.Database;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.core.CBLVersion;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseImmutableReplicatorConfiguration {
    @NonNull
    private final Database database;
    @NonNull
    private final ReplicatorType type;
    private final boolean continuous;
    @Nullable
    private final Authenticator authenticator;
    @Nullable
    private final Map<String, String> headers;
    @Nullable
    private final byte[] pinnedServerCertificate;
    @Nullable
    private final List<String> channels;
    @Nullable
    private final List<String> documentIDs;
    @Nullable
    private final ReplicationFilter pushFilter;
    @Nullable
    private final ReplicationFilter pullFilter;
    @Nullable
    private final ConflictResolver conflictResolver;
    private final int maxRetryAttempts;
    private final int maxRetryAttemptWaitTime;
    private final int heartbeat;
    private final boolean enableAutoPurge;
    @NonNull
    private final Endpoint target;

    protected BaseImmutableReplicatorConfiguration(@NonNull ReplicatorConfiguration config) {
        this.database = config.getDatabase();
        this.type = config.getType();
        this.continuous = config.isContinuous();
        this.authenticator = config.getAuthenticator();
        this.headers = config.getHeaders();
        this.pinnedServerCertificate = config.getPinnedServerCertificate();
        this.channels = config.getChannels();
        this.documentIDs = config.getDocumentIDs();
        this.pushFilter = config.getPushFilter();
        this.pullFilter = config.getPullFilter();
        this.conflictResolver = config.getConflictResolver();
        this.maxRetryAttempts = config.getMaxAttempts();
        this.maxRetryAttemptWaitTime = config.getMaxAttemptWaitTime();
        this.heartbeat = config.getHeartbeat();
        this.enableAutoPurge = config.isAutoPurgeEnabled();
        this.target = config.getTarget();
    }

    @NonNull
    public final Database getDatabase() {
        return this.database;
    }

    @NonNull
    public final ReplicatorType getType() {
        return this.type;
    }

    public final boolean isPush() {
        return this.type == ReplicatorType.PUSH_AND_PULL || this.type == ReplicatorType.PUSH;
    }

    public final boolean isPull() {
        return this.type == ReplicatorType.PUSH_AND_PULL || this.type == ReplicatorType.PULL;
    }

    public final boolean isContinuous() {
        return this.continuous;
    }

    @Nullable
    public final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    @Nullable
    public final byte[] getPinnedServerCertificate() {
        return this.pinnedServerCertificate;
    }

    @Nullable
    public final List<String> getChannels() {
        return this.channels;
    }

    @Nullable
    public final List<String> getDocumentIDs() {
        return this.documentIDs;
    }

    @Nullable
    public final ReplicationFilter getPushFilter() {
        return this.pushFilter;
    }

    @Nullable
    public final ReplicationFilter getPullFilter() {
        return this.pullFilter;
    }

    @Nullable
    public final ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public final int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public final int getMaxRetryAttemptWaitTime() {
        return this.maxRetryAttemptWaitTime;
    }

    public final int getHeartbeat() {
        return this.heartbeat;
    }

    public final boolean isAutoPurgeEnabled() {
        return this.enableAutoPurge;
    }

    @NonNull
    public final Endpoint getTarget() {
        return this.target;
    }

    @NonNull
    public Map<String, Object> getConnectionOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.authenticator != null) {
            ((BaseAuthenticator)this.authenticator).authenticate(options);
        }
        if (this.pinnedServerCertificate != null) {
            options.put("pinnedCert", this.pinnedServerCertificate);
        }
        if (this.documentIDs != null && !this.documentIDs.isEmpty()) {
            options.put("docIDs", this.documentIDs);
        }
        if (this.channels != null && !this.channels.isEmpty()) {
            options.put("channels", this.channels);
        }
        if (this.heartbeat > 0) {
            options.put("heartbeat", this.heartbeat);
        }
        if (this.maxRetryAttempts > 0) {
            options.put("maxRetries", this.maxRetryAttempts - 1);
        }
        if (this.maxRetryAttemptWaitTime > 0) {
            options.put("maxRetryInterval", this.maxRetryAttemptWaitTime);
        }
        if (!this.enableAutoPurge) {
            options.put("autoPurge", Boolean.FALSE);
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("User-Agent", CBLVersion.getUserAgent());
        if (this.headers != null) {
            String customCookies = this.headers.remove("Cookies");
            if (customCookies != null) {
                Object currentCookies = options.get("cookies");
                String newCookies = !(currentCookies instanceof String) ? customCookies : (String)currentCookies + "; " + customCookies;
                options.put("cookies", newCookies);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                httpHeaders.put(entry.getKey(), entry.getValue());
            }
        }
        options.put("headers", httpHeaders);
        return options;
    }
}

