/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public final class AndroidExecutionService
extends AbstractExecutionService {
    @NonNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @NonNull
    private final Executor mainThreadExecutor = arg_0 -> ((Handler)this.mainHandler).post(arg_0);

    public AndroidExecutionService() {
        this(new CBLExecutor("CBL worker"));
    }

    @VisibleForTesting
    public AndroidExecutionService(@NonNull ThreadPoolExecutor executor) {
        super(executor);
    }

    @Override
    @NonNull
    public Executor getDefaultExecutor() {
        return this.mainThreadExecutor;
    }

    @Override
    @NonNull
    public ExecutionService.Cancellable postDelayedOnExecutor(long delayMs, @NonNull Executor executor, @NonNull Runnable task) {
        Preconditions.assertNotNull(executor, "executor");
        Preconditions.assertNotNull(task, "task");
        Runnable delayedTask = () -> {
            block3: {
                try {
                    executor.execute(task);
                }
                catch (ExecutionService.CloseableExecutor.ExecutorClosedException e) {
                    Log.w(LogDomain.DATABASE, "Scheduled on closed executor: " + task + ", " + executor);
                }
                catch (RejectedExecutionException e) {
                    if (AndroidExecutionService.throttled()) break block3;
                    Log.w(LogDomain.DATABASE, "!!! Execution rejected after delay: " + delayMs, e);
                    AndroidExecutionService.dumpThreads();
                }
            }
        };
        this.mainHandler.postDelayed(delayedTask, delayMs);
        return new CancellableTask(this.mainHandler, delayedTask);
    }

    private static final class CancellableTask
    implements ExecutionService.Cancellable {
        private final Handler handler;
        private final Runnable task;

        private CancellableTask(@NonNull Handler handler, @NonNull Runnable task) {
            Preconditions.assertNotNull(handler, "handler");
            Preconditions.assertNotNull(task, "task");
            this.handler = handler;
            this.task = task;
        }

        @Override
        public void cancel() {
            this.handler.removeCallbacks(this.task);
        }
    }
}

