/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4DocumentEnded;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4ReplicatorListener;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.support.Log;
import java.util.concurrent.Executor;

final class ReplicatorListener
implements C4ReplicatorListener {
    private static final LogDomain DOMAIN = LogDomain.REPLICATOR;
    private final Executor dispatcher;

    ReplicatorListener(@NonNull Executor dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void statusChanged(@Nullable C4Replicator c4Repl, @Nullable C4ReplicatorStatus status, @Nullable Object repl) {
        Log.i(DOMAIN, "ReplicatorListener.statusChanged, repl: %s, status: %s", repl, status);
        AbstractReplicator replicator = this.verifyReplicator(c4Repl, repl);
        if (replicator == null) {
            return;
        }
        if (status == null) {
            Log.w(DOMAIN, "C4ReplicatorListener.statusChanged, status is null");
            return;
        }
        this.dispatcher.execute(() -> replicator.c4StatusChanged(status));
    }

    @Override
    public void documentEnded(@NonNull C4Replicator c4Repl, boolean pushing, @Nullable C4DocumentEnded[] documents, @Nullable Object repl) {
        Log.i(DOMAIN, "C4ReplicatorListener.documentEnded, repl: %s, pushing: %s", repl, pushing);
        if (!(repl instanceof AbstractReplicator)) {
            Log.w(DOMAIN, "C4ReplicatorListener.documentEnded, repl is null");
            return;
        }
        AbstractReplicator replicator = this.verifyReplicator(c4Repl, repl);
        if (replicator == null) {
            return;
        }
        if (documents == null) {
            Log.w(DOMAIN, "C4ReplicatorListener.documentEnded, documents is null");
            return;
        }
        this.dispatcher.execute(() -> replicator.documentEnded(pushing, documents));
    }

    @Nullable
    private AbstractReplicator verifyReplicator(@Nullable C4Replicator c4Repl, @Nullable Object repl) {
        AbstractReplicator replicator;
        AbstractReplicator abstractReplicator = replicator = !(repl instanceof AbstractReplicator) ? null : (AbstractReplicator)repl;
        if (replicator != null && c4Repl == replicator.getC4Replicator()) {
            return replicator;
        }
        Log.w(DOMAIN, "C4ReplicatorListener: c4replicator and replicator don't match: %s :: %s", c4Repl, repl);
        return null;
    }
}

