/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.URLEndpoint;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.replicator.AndroidConnectivityObserver;
import com.couchbase.lite.internal.replicator.NetworkConnectivityManager;

public final class Replicator
extends AbstractReplicator {
    @Nullable
    private final AndroidConnectivityObserver connectivityObserver;

    public Replicator(@NonNull ReplicatorConfiguration config) {
        this(CouchbaseLiteInternal.getNetworkConnectivityManager(), config);
    }

    @VisibleForTesting
    Replicator(@Nullable NetworkConnectivityManager mgr, @NonNull ReplicatorConfiguration config) {
        super(config);
        this.connectivityObserver = !config.isContinuous() || mgr == null ? null : new AndroidConnectivityObserver(mgr, this::getC4Replicator);
    }

    @Override
    @NonNull
    protected C4Replicator createReplicatorForTarget(@NonNull Endpoint target) throws LiteCoreException {
        if (target instanceof URLEndpoint) {
            return this.getRemoteC4Replicator(((URLEndpoint)target).getURL());
        }
        throw new IllegalStateException("unrecognized endpoint type: " + target);
    }

    @Override
    protected void handleOffline(@NonNull ReplicatorActivityLevel prevState, boolean nowOnline) {
        if (this.connectivityObserver != null) {
            this.connectivityObserver.handleOffline(prevState, nowOnline);
        }
    }
}

