/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;

final class MValueDelegate
implements MValue.Delegate {
    MValueDelegate() {
    }

    @Override
    @Nullable
    public Object toNative(@NonNull MValue mv, @Nullable MCollection parent, @NonNull AtomicBoolean cacheIt) {
        FLValue value = Preconditions.assertNotNull(mv.getValue(), "MValue");
        switch (value.getType()) {
            case 5: {
                cacheIt.set(true);
                return this.mValueToArray(mv, parent);
            }
            case 6: {
                cacheIt.set(true);
                return this.mValueToDictionary(mv, parent);
            }
            case 4: {
                return new Blob("application/octet-stream", value.asData());
            }
        }
        return value.asObject();
    }

    @Override
    @Nullable
    public MCollection collectionFromNative(@Nullable Object object) {
        if (object instanceof Dictionary) {
            return ((Dictionary)object).toMCollection();
        }
        if (object instanceof Array) {
            return ((Array)object).toMCollection();
        }
        return null;
    }

    @Override
    public void encodeNative(@NonNull FLEncoder enc, @Nullable Object object) {
        if (object == null) {
            enc.writeNull();
        } else {
            enc.writeValue(object);
        }
    }

    @NonNull
    private Object mValueToArray(@NonNull MValue mv, @Nullable MCollection parent) {
        return parent == null || !parent.hasMutableChildren() ? new Array(mv, parent) : new MutableArray(mv, parent);
    }

    @NonNull
    private Object mValueToDictionary(@NonNull MValue mv, @NonNull MCollection parent) {
        String type;
        FLDict flDict = Preconditions.assertNotNull(mv.getValue(), "MValue").asFLDict();
        DbContext context = (DbContext)parent.getContext();
        FLValue flType = flDict.get("@type");
        String string = type = flType == null ? null : flType.asString();
        if (type == null) {
            if (this.isOldAttachment(parent, flDict)) {
                return this.createBlob(flDict, context);
            }
        } else {
            Object obj = this.createSpecialObjectOfType(type, flDict, context);
            if (obj != null) {
                return obj;
            }
        }
        if (parent.hasMutableChildren()) {
            return new MutableDictionary(mv, parent);
        }
        return new Dictionary(mv, parent);
    }

    @Nullable
    private Object createSpecialObjectOfType(@Nullable String type, @NonNull FLDict props, @NonNull DbContext ctxt) {
        return !"blob".equals(type) ? null : this.createBlob(props, ctxt);
    }

    @NonNull
    private Object createBlob(@NonNull FLDict props, @NonNull DbContext ctxt) {
        return new Blob(Preconditions.assertNotNull(ctxt.getDatabase(), "database"), props.asDict());
    }

    private boolean isOldAttachment(@NonNull MCollection parent, @NonNull FLDict flDict) {
        return flDict.get("digest") != null && flDict.get("length") != null && flDict.get("stub") != null && flDict.get("revpos") != null;
    }
}

