/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Objects;

public final class LogFileConfiguration {
    private final boolean readonly;
    @NonNull
    private final String directory;
    private boolean usePlaintext;
    private int maxRotateCount = 1;
    private long maxSize;

    public LogFileConfiguration(@NonNull String directory) {
        this(directory, null);
    }

    public LogFileConfiguration(@NonNull LogFileConfiguration config) {
        this(config == null ? null : config.getDirectory(), config);
    }

    public LogFileConfiguration(@NonNull String directory, @Nullable LogFileConfiguration config) {
        this(directory, config, false);
    }

    LogFileConfiguration(@NonNull String directory, @Nullable LogFileConfiguration config, boolean readonly) {
        this(Preconditions.assertNotNull(directory, "directory"), config == null ? null : Long.valueOf(config.maxSize), config == null ? null : Integer.valueOf(config.maxRotateCount), config == null ? null : Boolean.valueOf(config.usePlaintext), readonly);
    }

    LogFileConfiguration(@NonNull String directory, @Nullable Long maxSize, @Nullable Integer maxRotateCount, @Nullable Boolean usePlaintext, boolean readonly) {
        this.directory = Preconditions.assertNotNull(directory, "directory");
        this.maxSize = maxSize == null ? 512000L : maxSize;
        this.maxRotateCount = maxRotateCount == null ? 1 : maxRotateCount;
        this.usePlaintext = usePlaintext != null && usePlaintext != false;
        this.readonly = readonly;
    }

    @NonNull
    public LogFileConfiguration setUsePlaintext(boolean usePlaintext) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.usePlaintext = usePlaintext;
        return this;
    }

    public int getMaxRotateCount() {
        return this.maxRotateCount;
    }

    @NonNull
    public LogFileConfiguration setMaxRotateCount(int maxRotateCount) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.maxRotateCount = maxRotateCount;
        return this;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @NonNull
    public LogFileConfiguration setMaxSize(long maxSize) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.maxSize = maxSize;
        return this;
    }

    public boolean usesPlaintext() {
        return this.usePlaintext;
    }

    @NonNull
    public String getDirectory() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogFileConfiguration)) {
            return false;
        }
        LogFileConfiguration that = (LogFileConfiguration)o;
        return this.maxRotateCount == that.maxRotateCount && this.directory.equals(that.directory) && this.maxSize == that.maxSize && this.usePlaintext == that.usePlaintext;
    }

    public int hashCode() {
        return Objects.hash(this.directory);
    }
}

