/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.ChangeListenerToken;
import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DatabaseChange;
import com.couchbase.lite.DatabaseChangeListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.QueryChange;
import com.couchbase.lite.QueryChangeListener;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

final class LiveQuery
implements DatabaseChangeListener {
    private static final LogDomain DOMAIN = LogDomain.QUERY;
    @VisibleForTesting
    static final long LIVE_QUERY_UPDATE_INTERVAL_MS = 200L;
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final ChangeNotifier<QueryChange> changeNotifier = new ChangeNotifier();
    @NonNull
    private final AbstractQuery query;
    @NonNull
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    @GuardedBy(value="lock")
    @Nullable
    private ListenerToken dbListenerToken;
    @GuardedBy(value="lock")
    @Nullable
    private ResultSet previousResults;

    LiveQuery(@NonNull AbstractQuery query) {
        Preconditions.assertNotNull(query, "query");
        this.query = query;
    }

    @NonNull
    public String toString() {
        return "LiveQuery{" + ClassUtils.objId(this) + "," + this.query.toString() + "}";
    }

    @Override
    public void changed(@NonNull DatabaseChange change) {
        this.update(200L);
    }

    @NonNull
    ListenerToken addChangeListener(@Nullable Executor executor, @NonNull QueryChangeListener listener) {
        ChangeListenerToken<QueryChange> token = this.changeNotifier.addChangeListener(executor, listener);
        this.start(false);
        return token;
    }

    void removeChangeListener(@NonNull ListenerToken token) {
        if (this.changeNotifier.removeChangeListener(token) <= 0) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(boolean shouldClearResults) {
        AbstractDatabase db = Preconditions.assertNotNull(this.query.getDatabase(), "Live query database");
        Object object = db.getDbLock();
        synchronized (object) {
            db.mustBeOpen();
            if (this.state.compareAndSet(State.STOPPED, State.STARTED)) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.dbListenerToken = db.addActiveLiveQuery(this);
                }
            }
            if (shouldClearResults) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.closePrevResults();
                }
            }
        }
        this.update(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        AbstractDatabase db = this.query.getDatabase();
        if (db == null) {
            if (State.STOPPED != this.state.get()) {
                Log.w(LogDomain.DATABASE, "Null db when stopping LiveQuery");
            }
            return;
        }
        Object object = db.getDbLock();
        synchronized (object) {
            if (State.STOPPED == this.state.getAndSet(State.STOPPED)) {
                return;
            }
            Object object2 = this.lock;
            synchronized (object2) {
                this.closePrevResults();
                ListenerToken token = this.dbListenerToken;
                this.dbListenerToken = null;
                if (token == null) {
                    return;
                }
                db.removeActiveLiveQuery(this, token);
            }
        }
    }

    @NonNull
    State getState() {
        return this.state.get();
    }

    private void update(long delay) {
        if (!this.state.compareAndSet(State.STARTED, State.SCHEDULED)) {
            return;
        }
        AbstractDatabase db = this.query.getDatabase();
        if (db == null) {
            throw new IllegalStateException("Live query with no database");
        }
        db.scheduleOnQueryExecutor(this::refreshResults, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshResults() {
        try {
            ResultSet prevResults;
            Object object = this.lock;
            synchronized (object) {
                if (!this.state.compareAndSet(State.SCHEDULED, State.STARTED)) {
                    return;
                }
                prevResults = this.previousResults;
            }
            ResultSet newResults = prevResults == null ? this.query.execute() : prevResults.refresh();
            Log.i(DOMAIN, "LiveQuery refresh: %s -> %s", prevResults, newResults);
            if (newResults == null) {
                return;
            }
            if (prevResults != null) {
                prevResults.close();
            }
            boolean update = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.state.get() != State.STOPPED) {
                    this.previousResults = newResults;
                    update = true;
                }
            }
            if (update) {
                this.changeNotifier.postChange(() -> new QueryChange(this.query, newResults.copy(), null));
            }
        }
        catch (CouchbaseLiteException err) {
            this.changeNotifier.postChange(new QueryChange(this.query, null, err));
        }
    }

    @GuardedBy(value="lock")
    private void closePrevResults() {
        if (this.previousResults == null) {
            return;
        }
        this.previousResults.close();
        this.previousResults = null;
    }

    @VisibleForTesting
    static enum State {
        STOPPED,
        STARTED,
        SCHEDULED;

    }
}

