/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FullTextIndexConfiguration
extends IndexConfiguration {
    @Nullable
    private String textLanguage = Locale.getDefault().getLanguage();
    private boolean ignoreDiacritics;

    public FullTextIndexConfiguration(String ... expressions) {
        super(AbstractIndex.IndexType.FULL_TEXT, Arrays.asList(expressions));
    }

    public FullTextIndexConfiguration(@NonNull List<String> expressions) {
        super(AbstractIndex.IndexType.FULL_TEXT, expressions);
    }

    @NonNull
    public FullTextIndexConfiguration setLanguage(@Nullable String language) {
        this.textLanguage = StringUtils.isEmpty(language) ? null : language;
        return this;
    }

    @Override
    @Nullable
    public String getLanguage() {
        return this.textLanguage;
    }

    @NonNull
    public FullTextIndexConfiguration ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacritics = ignoreAccents;
        return this;
    }

    @Override
    public boolean isIgnoringAccents() {
        return this.ignoreDiacritics;
    }
}

