/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.FullTextIndexItem;
import com.couchbase.lite.Index;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FullTextIndex
extends Index {
    @NonNull
    private final List<FullTextIndexItem> indexItems;
    @Nullable
    private String language = Locale.getDefault().getLanguage();
    private boolean ignoreDiacritics;

    FullTextIndex(FullTextIndexItem ... indexItems) {
        super(AbstractIndex.IndexType.FULL_TEXT);
        this.indexItems = Arrays.asList(indexItems);
    }

    @NonNull
    public FullTextIndex setLanguage(@Nullable String language) {
        this.language = StringUtils.isEmpty(language) ? null : language;
        return this;
    }

    @NonNull
    public FullTextIndex ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacritics = ignoreAccents;
        return this;
    }

    @Override
    @Nullable
    String getLanguage() {
        return this.language;
    }

    @Override
    boolean isIgnoringAccents() {
        return this.ignoreDiacritics;
    }

    @Override
    @NonNull
    List<Object> getJson() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (FullTextIndexItem item : this.indexItems) {
            items.add(item.expression.asJSON());
        }
        return items;
    }
}

