/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.JSONUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class Fleece {
    private static final String SUPPORTED_TYPES = "MutableDictionary, Dictionary, MutableArray, Array, Map, List, Date, String, Number, Boolean, Blob or null";

    private Fleece() {
    }

    static boolean willMutate(Object newValue, @NonNull MValue oldValue, MCollection container) {
        FLValue val = oldValue.getValue();
        int oldType = val != null ? val.getType() : -1;
        return oldType == -1 || oldType == 6 || newValue instanceof Dictionary || oldType == 5 || newValue instanceof Array || !Objects.equals(newValue, oldValue.asNative(container));
    }

    @Nullable
    static Object toCBLObject(@Nullable Object value) {
        if (value == null || value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof Blob || value instanceof MutableArray || value instanceof MutableDictionary) {
            return value;
        }
        if (value instanceof Map) {
            return new MutableDictionary((Map)value);
        }
        if (value instanceof Dictionary) {
            return ((Dictionary)value).toMutable();
        }
        if (value instanceof List) {
            return new MutableArray((List)value);
        }
        if (value instanceof Array) {
            return ((Array)value).toMutable();
        }
        if (value instanceof Date) {
            return JSONUtils.toJSONString((Date)value);
        }
        throw new IllegalArgumentException(Log.formatStandardMessage("InvalidValueToBeDeserialized", value.getClass().getSimpleName(), SUPPORTED_TYPES));
    }

    @Nullable
    static Object toObject(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Dictionary) {
            return ((Dictionary)value).toMap();
        }
        if (value instanceof Array) {
            return ((Array)value).toList();
        }
        return value;
    }
}

