/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Blob;
import com.couchbase.lite.ChangeListenerToken;
import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.ConcurrencyControl;
import com.couchbase.lite.Conflict;
import com.couchbase.lite.ConflictHandler;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseChange;
import com.couchbase.lite.DatabaseChangeListener;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.DocumentChangeListener;
import com.couchbase.lite.DocumentChangeNotifier;
import com.couchbase.lite.Index;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LiveQuery;
import com.couchbase.lite.Log;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MaintenanceType;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.N1qlQuery;
import com.couchbase.lite.Query;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.UnitOfWork;
import com.couchbase.lite.internal.CBLInternalException;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.ImmutableDatabaseConfiguration;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4DatabaseChange;
import com.couchbase.lite.internal.core.C4DatabaseObserver;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4DocumentObserver;
import com.couchbase.lite.internal.core.C4DocumentObserverListener;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4ReplicationFilter;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4ReplicatorListener;
import com.couchbase.lite.internal.core.SharedKeys;
import com.couchbase.lite.internal.exec.ClientTask;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.PlatformUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

abstract class AbstractDatabase
extends BaseDatabase {
    @NonNull
    public static final Log log = new Log();
    private static final String ERROR_RESOLVER_FAILED = "Conflict resolution failed for document '%s': %s";
    private static final String WARN_WRONG_DATABASE = "The database to which the document produced by conflict resolution for document '%s' belongs, '%s', is not the one in which it will be stored (%s)";
    private static final String WARN_WRONG_ID = "The ID of the document produced by conflict resolution for document (%s) does not match the IDs of the conflicting documents (%s)";
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    private static final int MAX_CHANGES = 100;
    private static final int DB_CLOSE_WAIT_SECS = 6;
    private static final int DB_CLOSE_MAX_RETRIES = 5;
    private static final int EXECUTOR_CLOSE_MAX_WAIT_SECS = 5;
    private static final String INDEX_KEY_NAME = "name";
    private static final int MAX_CONFLICT_RESOLUTION_RETRIES = 13;
    private static final int DEFAULT_DATABASE_FLAGS = 21;
    @NonNull
    protected final ImmutableDatabaseConfiguration config;
    @NonNull
    private final String name;
    private final ExecutionService.CloseableExecutor postExecutor;
    private final ExecutionService.CloseableExecutor queryExecutor;
    private final SharedKeys sharedKeys;
    @GuardedBy(value="activeProcesses")
    private final Set<ActiveProcess<?>> activeProcesses;
    @GuardedBy(value="getDbLock()")
    private final Map<String, DocumentChangeNotifier> docChangeNotifiers;
    @GuardedBy(value="getDbLock()")
    private ChangeNotifier<DatabaseChange> dbChangeNotifier;
    @GuardedBy(value="getDbLock()")
    private C4DatabaseObserver c4DbObserver;
    private volatile CountDownLatch closeLatch;

    public static void delete(@NonNull String name, @Nullable File directory) throws CouchbaseLiteException {
        Preconditions.assertNotNull(name, INDEX_KEY_NAME);
        if (directory == null) {
            directory = CouchbaseLiteInternal.getRootDir();
        }
        if (!AbstractDatabase.exists(name, directory)) {
            throw new CouchbaseLiteException("Database not found for delete", "CouchbaseLite", 7);
        }
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Delete database %s in %s", name, directory);
        try {
            C4Database.deleteNamedDb(directory.getCanonicalPath(), name);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        catch (IOException e) {
            throw new CouchbaseLiteException("No canonical path for " + directory, e);
        }
    }

    public static boolean exists(@NonNull String name, @NonNull File directory) {
        Preconditions.assertNotNull(name, INDEX_KEY_NAME);
        Preconditions.assertNotNull(directory, "directory");
        return C4Database.getDatabaseFile(directory, name).exists();
    }

    protected static void copy(@NonNull File path, @NonNull String name, @NonNull String dbDir, int algorithm, byte[] encryptionKey) throws CouchbaseLiteException {
        CouchbaseLiteException err;
        Preconditions.assertNotNull(path, "path");
        Preconditions.assertNotNull(name, INDEX_KEY_NAME);
        try {
            C4Database.copyDb(path.getCanonicalPath(), dbDir, name, 21, algorithm, encryptionKey);
            return;
        }
        catch (LiteCoreException e) {
            err = CouchbaseLiteException.convertException(e);
        }
        catch (IOException e) {
            err = new CouchbaseLiteException("Failed creating canonical path for " + path, e);
        }
        FileUtils.eraseFileOrDir(C4Database.getDatabaseFile(new File(dbDir), name));
        throw err;
    }

    protected AbstractDatabase(@NonNull String name) throws CouchbaseLiteException {
        this(name, new ImmutableDatabaseConfiguration(null));
    }

    protected AbstractDatabase(@NonNull String name, @NonNull DatabaseConfiguration config) throws CouchbaseLiteException {
        this(name, new ImmutableDatabaseConfiguration(config));
    }

    protected AbstractDatabase(@NonNull String name, @NonNull ImmutableDatabaseConfiguration config) throws CouchbaseLiteException {
        Preconditions.assertNotEmpty(name, "db name");
        Preconditions.assertNotNull(config, "config");
        CouchbaseLiteInternal.requireInit("Cannot create database");
        this.name = name;
        this.config = config;
        this.postExecutor = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
        this.queryExecutor = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
        this.activeProcesses = new HashSet();
        this.docChangeNotifiers = new HashMap<String, DocumentChangeNotifier>();
        this.fixHydrogenBug(config, name);
        C4Database c4db = this.openC4Db();
        this.setC4DatabaseLocked(c4db);
        this.sharedKeys = new SharedKeys(c4db);
        com.couchbase.lite.internal.support.Log.warn();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPath() {
        Object object = this.getDbLock();
        synchronized (object) {
            return !this.isOpen() ? null : this.getDbPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Object object = this.getDbLock();
        synchronized (object) {
            return !this.isOpen() ? 0L : this.getOpenC4DbLocked().getDocumentCount();
        }
    }

    @NonNull
    public DatabaseConfiguration getConfig() {
        return new DatabaseConfiguration(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NonNull String id) {
        Preconditions.assertNotEmpty(id, "id");
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
            try {
                return Document.getDocument((Database)this, id, false);
            }
            catch (CouchbaseLiteException e) {
                com.couchbase.lite.internal.support.Log.i(LogDomain.DATABASE, "Failed retrieving document: %s", e, id);
            }
        }
        return null;
    }

    public void save(@NonNull MutableDocument document) throws CouchbaseLiteException {
        this.save(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean save(@NonNull MutableDocument document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        try {
            this.saveInternal(document, null, false, concurrencyControl);
            return true;
        }
        catch (CouchbaseLiteException e) {
            if (!CouchbaseLiteException.isConflict(e)) {
                throw e;
            }
            return false;
        }
    }

    public boolean save(@NonNull MutableDocument document, @NonNull ConflictHandler conflictHandler) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        Preconditions.assertNotNull(conflictHandler, "conflictHandler");
        this.saveWithConflictHandler(document, conflictHandler);
        return true;
    }

    public void delete(@NonNull Document document) throws CouchbaseLiteException {
        this.delete(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean delete(@NonNull Document document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        try {
            this.saveInternal(document, null, true, concurrencyControl);
            return true;
        }
        catch (CouchbaseLiteException e) {
            if (!CouchbaseLiteException.isConflict(e)) {
                throw e;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(@NonNull Document document) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        if (document.isNewDocument()) {
            throw new CouchbaseLiteException("DocumentNotFound", "CouchbaseLite", 7);
        }
        Object object = this.getDbLock();
        synchronized (object) {
            block6: {
                this.prepareDocument(document);
                try {
                    this.purge(document.getId());
                }
                catch (CouchbaseLiteException e) {
                    if (e.getCode() == 7) break block6;
                    throw e;
                }
            }
            document.replaceC4Document(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(@NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        Object object = this.getDbLock();
        synchronized (object) {
            this.purgeLocked(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentExpiration(@NonNull String id, @Nullable Date expiration) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                this.getOpenC4DbLocked().setExpiration(id, expiration == null ? 0L : expiration.getTime());
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    @Nullable
    public Date getDocumentExpiration(@NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                long timestamp = this.getOpenC4DbLocked().getExpiration(id);
                return timestamp == 0L ? null : new Date(timestamp);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void inBatch(@NonNull UnitOfWork<T> work) throws CouchbaseLiteException, T {
        Preconditions.assertNotNull(work, "work");
        Object object = this.getDbLock();
        synchronized (object) {
            C4Database db = this.getOpenC4DbLocked();
            boolean commit = false;
            try {
                db.beginTransaction();
                try {
                    work.run();
                    commit = true;
                }
                finally {
                    db.endTransaction(commit);
                }
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        this.postDatabaseChanged();
    }

    @NonNull
    public ListenerToken addChangeListener(@NonNull DatabaseChangeListener listener) {
        return this.addChangeListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull DatabaseChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
            return this.addDatabaseChangeListenerLocked(executor, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        Object object = this.getDbLock();
        synchronized (object) {
            ChangeListenerToken changeListenerToken;
            if (token instanceof ChangeListenerToken && (changeListenerToken = (ChangeListenerToken)token).getKey() != null) {
                this.removeDocumentChangeListenerLocked(changeListenerToken);
                return;
            }
            this.removeDatabaseChangeListenerLocked(token);
        }
    }

    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, @NonNull DocumentChangeListener listener) {
        return this.addDocumentChangeListener(id, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, @Nullable Executor executor, @NonNull DocumentChangeListener listener) {
        Preconditions.assertNotNull(id, "id");
        Preconditions.assertNotNull(listener, "listener");
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
            return this.addDocumentChangeListenerLocked(id, executor, listener);
        }
    }

    public void close() throws CouchbaseLiteException {
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Closing %s at path %s", this, this.getDbPath());
        this.shutdown(false, C4Database::closeDb);
    }

    public void delete() throws CouchbaseLiteException {
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Deleting %s at path %s", this, this.getDbPath());
        this.shutdown(true, C4Database::deleteDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Query createQuery(@NonNull String query) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
            N1qlQuery n1qlQuery = new N1qlQuery(this, query);
            n1qlQuery.compile();
            return n1qlQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<String> getIndexes() throws CouchbaseLiteException {
        FLValue flIndexInfo;
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                flIndexInfo = this.getOpenC4DbLocked().getIndexesInfo();
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        ArrayList<String> indexNames = new ArrayList<String>();
        Object indexesInfo = flIndexInfo.asObject();
        if (!(indexesInfo instanceof List)) {
            return indexNames;
        }
        for (Object idxInfo : (List)indexesInfo) {
            Object idxName;
            if (!(idxInfo instanceof Map) || !((idxName = ((Map)idxInfo).get(INDEX_KEY_NAME)) instanceof String)) continue;
            indexNames.add((String)idxName);
        }
        return indexNames;
    }

    public void createIndex(@NonNull String name, @NonNull Index index) throws CouchbaseLiteException {
        this.createIndexInternal(name, index);
    }

    public void createIndex(@NonNull String name, @NonNull IndexConfiguration config) throws CouchbaseLiteException {
        this.createIndexInternal(name, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(@NonNull String name) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                this.getOpenC4DbLocked().deleteIndex(name);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    public boolean performMaintenance(MaintenanceType type) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                return this.getOpenC4DbLocked().performMaintenance(type);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBlob(@NonNull Blob blob) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
        }
        blob.installInDatabase((Database)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Blob getBlob(@NonNull Map<String, Object> props) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
        }
        if (!Blob.isBlob(props)) {
            throw new IllegalArgumentException("getBlob arg does not specify a blob");
        }
        Blob blob = new Blob(this, props);
        return blob.updateSize() < 0L ? null : blob;
    }

    @NonNull
    public String toString() {
        return "Database{" + ClassUtils.objId(this) + ", name='" + this.name + "'}";
    }

    protected void finalize() throws Throwable {
        try {
            C4DatabaseObserver observer = this.c4DbObserver;
            if (observer != null) {
                observer.close();
            }
            this.shutdownActiveProcesses(this.activeProcesses);
            this.shutdownExecutors(this.postExecutor, this.queryExecutor, 0);
        }
        finally {
            super.finalize();
        }
    }

    boolean equalsWithPath(Database other) {
        if (other == null) {
            return false;
        }
        File path = this.getFilePath();
        File otherPath = other.getFilePath();
        if (path == null && otherPath == null) {
            return true;
        }
        return path != null && path.equals(otherPath);
    }

    @NonNull
    Database copy() throws CouchbaseLiteException {
        return new Database(this.name, this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getUuid() {
        byte[] uuid = null;
        LiteCoreException err = null;
        Object object = this.getDbLock();
        synchronized (object) {
            if (!this.isOpen()) {
                return null;
            }
            try {
                uuid = this.getOpenC4DbLocked().getPublicUUID();
            }
            catch (LiteCoreException e) {
                err = e;
            }
        }
        if (err != null) {
            com.couchbase.lite.internal.support.Log.w(DOMAIN, "Failed retrieving database UUID", err);
        }
        return uuid == null ? null : PlatformUtils.getEncoder().encodeToString(uuid);
    }

    @Nullable
    File getFilePath() {
        String path = this.getPath();
        return path == null ? null : new File(path);
    }

    @Nullable
    File getDbFile() {
        String path = this.getDbPath();
        return path == null ? null : new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenerToken addActiveLiveQuery(final @NonNull LiveQuery query) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
        }
        this.registerProcess(new ActiveProcess<LiveQuery>(query){

            @Override
            public void stop() {
                query.stop();
            }

            @Override
            public boolean isActive() {
                return !LiveQuery.State.STOPPED.equals((Object)query.getState());
            }
        });
        return this.addChangeListener(query);
    }

    void removeActiveLiveQuery(@NonNull LiveQuery query, @NonNull ListenerToken token) {
        this.removeChangeListener(token);
        this.unregisterProcess(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Query createJsonQuery(@NonNull String json) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createJsonQuery(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Query createN1qlQuery(@NonNull String n1ql) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createN1qlQuery(n1ql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Document getC4Document(@NonNull String id) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    FLEncoder getSharedFleeceEncoder() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getSharedFleeceEncoder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4DocumentObserver createDocumentObserver(@NonNull ChangeNotifier<?> context, @NonNull String docID, @NonNull C4DocumentObserverListener listener) {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createDocumentObserver(docID, context, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Replicator createRemoteReplicator(@NonNull Replicator replicator, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDatabaseName, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @Nullable SocketFactory socketFactoryContext, int framing) throws LiteCoreException {
        C4Replicator c4Repl;
        Object object = this.getDbLock();
        synchronized (object) {
            c4Repl = this.getOpenC4DbLocked().createRemoteReplicator(scheme, host, port, path, remoteDatabaseName, push, pull, options, listener, pushFilter, pullFilter, replicator, socketFactoryContext, framing);
        }
        return c4Repl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Replicator createLocalReplicator(@NonNull Replicator replicator, @NonNull Database otherLocalDb, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter) throws LiteCoreException {
        C4Replicator c4Repl;
        Object object = this.getDbLock();
        synchronized (object) {
            c4Repl = this.getOpenC4DbLocked().createLocalReplicator(otherLocalDb.getOpenC4DbLocked(), push, pull, options, listener, pushFilter, pullFilter, replicator);
        }
        return c4Repl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveReplicator(final AbstractReplicator replicator) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.mustBeOpen();
        }
        this.registerProcess(new ActiveProcess<AbstractReplicator>(replicator){

            @Override
            public void stop() {
                replicator.stop();
            }

            @Override
            public boolean isActive() {
                return !ReplicatorActivityLevel.STOPPED.equals((Object)replicator.getState());
            }
        });
    }

    void removeActiveReplicator(AbstractReplicator replicator) {
        this.unregisterProcess(replicator);
    }

    void resolveReplicationConflict(@Nullable ConflictResolver resolver, @NonNull String docId, @NonNull Fn.Consumer<CouchbaseLiteException> callback) {
        int n = 0;
        CouchbaseLiteException err = null;
        try {
            while (true) {
                if (n++ > 13) {
                    err = new CouchbaseLiteException("Too many attempts to resolve a conflicted document: " + n, "CouchbaseLite", 10);
                    break;
                }
                try {
                    this.resolveConflictOnce(resolver, docId);
                    callback.accept(null);
                    return;
                }
                catch (CouchbaseLiteException e) {
                    if (CouchbaseLiteException.isConflict(e)) continue;
                    err = e;
                }
                catch (CBLInternalException e) {
                    if (e.getCode() != -101) {
                        err = new CouchbaseLiteException("Conflict resolution failed", e);
                    }
                }
                break;
            }
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            err = new CouchbaseLiteException(msg != null ? msg : "Conflict resolution failed", e, "CouchbaseLite", 10);
        }
        callback.accept(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCookie(@NonNull URI uri, @NonNull String setCookieHeader) {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                this.getOpenC4DbLocked().setCookie(uri, setCookieHeader);
            }
        }
        catch (LiteCoreException e) {
            com.couchbase.lite.internal.support.Log.w(DOMAIN, "Cannot save cookie for " + uri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getCookies(@NonNull URI uri) {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.getOpenC4DbLocked().getCookies(uri);
            }
        }
        catch (LiteCoreException e) {
            com.couchbase.lite.internal.support.Log.w(DOMAIN, "Cannot get cookies for " + uri, e);
            return null;
        }
    }

    void scheduleOnPostNotificationExecutor(@NonNull Runnable task, long delayMs) {
        CouchbaseLiteInternal.getExecutionService().postDelayedOnExecutor(delayMs, this.postExecutor, task);
    }

    void scheduleOnQueryExecutor(@NonNull Runnable task, long delayMs) {
        CouchbaseLiteInternal.getExecutionService().postDelayedOnExecutor(delayMs, this.queryExecutor, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerProcess(ActiveProcess<?> process) {
        Set<ActiveProcess<?>> set = this.activeProcesses;
        synchronized (set) {
            this.activeProcesses.add(process);
        }
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Added active process(%s): %s", this.getName(), process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void unregisterProcess(T process) {
        Set<ActiveProcess<?>> set = this.activeProcesses;
        synchronized (set) {
            this.activeProcesses.remove(new ActiveProcess<T>(process));
        }
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Removed active process(%s): %s", this.getName(), process);
        this.verifyActiveProcesses();
    }

    abstract int getEncryptionAlgorithm();

    @Nullable
    abstract byte[] getEncryptionKey();

    @GuardedBy(value="getDbLock()")
    private void beginTransaction() throws CouchbaseLiteException {
        try {
            this.getOpenC4DbLocked().beginTransaction();
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void endTransaction(boolean commit) throws CouchbaseLiteException {
        try {
            this.getOpenC4DbLocked().endTransaction(commit);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @NonNull
    private C4Database openC4Db() throws CouchbaseLiteException {
        String parentDirPath = this.config.getDirectory();
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Opening db %s at path %s", this, parentDirPath);
        try {
            return C4Database.getDatabase(parentDirPath, this.name, 21, this.getEncryptionAlgorithm(), this.getEncryptionKey());
        }
        catch (LiteCoreException e) {
            if (e.code == 20) {
                throw new CouchbaseLiteException("The provided encryption key was incorrect.", e, "CouchbaseLite", e.code);
            }
            if (e.code == 11) {
                throw new CouchbaseLiteException("CreateDBDirectoryFailed", e, "CouchbaseLite", e.code);
            }
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexInternal(@NonNull String name, @NonNull AbstractIndex config) throws CouchbaseLiteException {
        Preconditions.assertNotNull(name, INDEX_KEY_NAME);
        Preconditions.assertNotNull(config, "config");
        Object object = this.getDbLock();
        synchronized (object) {
            C4Database c4Db = this.getOpenC4DbLocked();
            try {
                c4Db.createIndex(name, config.getIndexSpec(), config.getQueryLanguage(), config.getIndexType(), config.getLanguage(), config.isIgnoringAccents());
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    private ListenerToken addDatabaseChangeListenerLocked(@Nullable Executor executor, @NonNull DatabaseChangeListener listener) {
        if (this.dbChangeNotifier == null) {
            this.dbChangeNotifier = new ChangeNotifier();
            this.registerC4DbObserver();
        }
        return this.dbChangeNotifier.addChangeListener(executor, listener);
    }

    @GuardedBy(value="getDbLock()")
    private void removeDatabaseChangeListenerLocked(@NonNull ListenerToken token) {
        if (this.dbChangeNotifier.removeChangeListener(token) == 0) {
            this.freeC4DbObserver();
            this.dbChangeNotifier = null;
        }
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    private ListenerToken addDocumentChangeListenerLocked(@NonNull String docID, @Nullable Executor executor, @NonNull DocumentChangeListener listener) {
        DocumentChangeNotifier docNotifier = this.docChangeNotifiers.get(docID);
        if (docNotifier == null) {
            docNotifier = new DocumentChangeNotifier((Database)this, docID);
            this.docChangeNotifiers.put(docID, docNotifier);
        }
        ChangeListenerToken<DocumentChange> token = docNotifier.addChangeListener(executor, listener);
        token.setKey(docID);
        return token;
    }

    @GuardedBy(value="getDbLock()")
    private void removeDocumentChangeListenerLocked(@NonNull ChangeListenerToken<?> token) {
        DocumentChangeNotifier notifier;
        String docID = (String)token.getKey();
        if (this.docChangeNotifiers.containsKey(docID) && (notifier = this.docChangeNotifiers.get(docID)) != null && notifier.removeChangeListener(token) == 0) {
            this.docChangeNotifiers.remove(docID);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void registerC4DbObserver() {
        if (!this.isOpen()) {
            return;
        }
        this.c4DbObserver = this.getOpenC4DbLocked().createDatabaseObserver(this, (observer, context) -> this.scheduleOnPostNotificationExecutor(this::postDatabaseChanged, 0L));
    }

    private void postDatabaseChanged() {
        Object object = this.getDbLock();
        synchronized (object) {
            if (!this.isOpen() || this.c4DbObserver == null) {
                return;
            }
            boolean external = false;
            ArrayList<String> docIDs = new ArrayList<String>();
            while (true) {
                List<C4DatabaseChange> c4DbChanges;
                int nChanges;
                if ((nChanges = (c4DbChanges = this.getDbChanges()).size()) <= 0) {
                    this.postChanges(docIDs);
                    return;
                }
                boolean newExternal = c4DbChanges.get(0).isExternal();
                if (docIDs.size() > 1000 || external != newExternal) {
                    this.postChanges(docIDs);
                    docIDs = new ArrayList();
                }
                for (C4DatabaseChange change : c4DbChanges) {
                    docIDs.add(change.getDocID());
                }
                external = newExternal;
            }
        }
    }

    @NonNull
    private List<C4DatabaseChange> getDbChanges() {
        ArrayList<C4DatabaseChange> changes = new ArrayList<C4DatabaseChange>();
        C4DatabaseChange[] c4DbChanges = this.c4DbObserver.getChanges(100);
        if (c4DbChanges != null) {
            for (C4DatabaseChange change : c4DbChanges) {
                if (change == null) continue;
                changes.add(change);
            }
        }
        return changes;
    }

    private void postChanges(List<String> docIds) {
        if (docIds.isEmpty()) {
            return;
        }
        this.dbChangeNotifier.postChange(new DatabaseChange((Database)this, docIds));
    }

    @GuardedBy(value="getDbLock()")
    private void prepareDocument(Document document) throws CouchbaseLiteException {
        this.mustBeOpen();
        Database db = document.getDatabase();
        if (db == null) {
            document.setDatabase((Database)this);
        } else if (db != this) {
            throw new CouchbaseLiteException("DocumentAnotherDatabase", "CouchbaseLite", 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveConflictOnce(@Nullable ConflictResolver resolver, @NonNull String docID) throws CouchbaseLiteException, CBLInternalException {
        Document remoteDoc;
        Document localDoc;
        Object object = this.getDbLock();
        synchronized (object) {
            localDoc = Document.getDocument((Database)this, docID);
            remoteDoc = this.getConflictingRevision(docID);
        }
        Document resolvedDoc = localDoc.isDeleted() && remoteDoc.isDeleted() ? remoteDoc : this.resolveConflict(resolver != null ? resolver : ConflictResolver.DEFAULT, docID, localDoc, remoteDoc);
        Object object2 = this.getDbLock();
        synchronized (object2) {
            boolean commit = false;
            this.beginTransaction();
            try {
                this.saveResolvedDocument(resolvedDoc, localDoc, remoteDoc);
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    @NonNull
    private Document getConflictingRevision(@NonNull String docID) throws CouchbaseLiteException, CBLInternalException {
        Document remoteDoc = Document.getDocument((Database)this, docID);
        try {
            if (!remoteDoc.selectConflictingRevision()) {
                String msg = "Unable to select conflicting revision for doc '" + docID + "'. Skipping.";
                com.couchbase.lite.internal.support.Log.w(DOMAIN, msg);
                throw new CBLInternalException(-101, msg);
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        return remoteDoc;
    }

    @Nullable
    private Document resolveConflict(@NonNull ConflictResolver resolver, @NonNull String docID, @NonNull Document localDoc, @NonNull Document remoteDoc) throws CouchbaseLiteException {
        Conflict conflict = new Conflict(localDoc.isDeleted() ? null : localDoc, remoteDoc.isDeleted() ? null : remoteDoc);
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Resolving doc '%s' (local=%s and remote=%s) with resolver %s", docID, localDoc.getRevisionID(), remoteDoc.getRevisionID(), resolver);
        ClientTask<Document> task = new ClientTask<Document>(() -> resolver.resolve(conflict));
        task.execute();
        Exception err = task.getFailure();
        if (err != null) {
            String msg = String.format(ERROR_RESOLVER_FAILED, docID, err.getLocalizedMessage());
            com.couchbase.lite.internal.support.Log.w(DOMAIN, msg, err);
            throw new CouchbaseLiteException(msg, err, "CouchbaseLite", 10);
        }
        Document doc = task.getResult();
        if (doc == null) {
            return null;
        }
        Database target = doc.getDatabase();
        if (!this.equals(target)) {
            if (target == null) {
                doc.setDatabase((Database)this);
            } else {
                String msg = String.format(WARN_WRONG_DATABASE, docID, target.getName(), this.getName());
                com.couchbase.lite.internal.support.Log.w(DOMAIN, msg);
                throw new CouchbaseLiteException(msg, "CouchbaseLite", 10);
            }
        }
        if (!docID.equals(doc.getId())) {
            com.couchbase.lite.internal.support.Log.w(DOMAIN, WARN_WRONG_ID, doc.getId(), docID);
            return new MutableDocument(docID, doc);
        }
        return doc;
    }

    @GuardedBy(value="getDbLock()")
    private void saveResolvedDocument(@Nullable Document resolvedDoc, @NonNull Document localDoc, @NonNull Document remoteDoc) throws CouchbaseLiteException {
        if (resolvedDoc == null) {
            if (remoteDoc.isDeleted()) {
                resolvedDoc = remoteDoc;
            } else if (localDoc.isDeleted()) {
                resolvedDoc = localDoc;
            }
        }
        int mergedFlags = 0;
        if (resolvedDoc != null) {
            C4Document c4Doc;
            if (resolvedDoc != localDoc) {
                resolvedDoc.setDatabase((Database)this);
            }
            if ((c4Doc = resolvedDoc.getC4doc()) != null) {
                mergedFlags = c4Doc.getSelectedFlags();
            }
        }
        try {
            this.saveResolvedDocumentWithFlags(resolvedDoc, localDoc, remoteDoc, mergedFlags);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void saveResolvedDocumentWithFlags(@Nullable Document resolvedDoc, @NonNull Document localDoc, @NonNull Document remoteDoc, int mergedFlags) throws LiteCoreException {
        byte[] mergedBodyBytes;
        block21: {
            mergedBodyBytes = null;
            if (resolvedDoc != remoteDoc) {
                if (resolvedDoc == null || resolvedDoc.isDeleted()) {
                    mergedFlags |= 1;
                    try (FLEncoder enc = this.getSharedFleeceEncoder();){
                        enc.writeValue(Collections.emptyMap());
                        try (FLSliceResult mergedBody = enc.finish2();){
                            mergedBodyBytes = mergedBody.getBuf();
                            break block21;
                        }
                    }
                }
                try (FLSliceResult mergedBody = resolvedDoc.encode();){
                    if (C4Document.dictContainsBlobs(mergedBody, this.sharedKeys.getFLSharedKeys())) {
                        mergedFlags |= 8;
                    }
                    mergedBodyBytes = mergedBody.getBuf();
                }
            }
        }
        C4Document rawDoc = Preconditions.assertNotNull(localDoc.getC4doc(), "raw doc is null");
        rawDoc.resolveConflict(remoteDoc.getRevisionID(), localDoc.getRevisionID(), mergedBodyBytes, mergedFlags);
        rawDoc.save(0);
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Conflict resolved as doc '%s' rev %s", rawDoc.getDocID(), rawDoc.getRevID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveWithConflictHandler(@NonNull MutableDocument document, @NonNull ConflictHandler handler) throws CouchbaseLiteException {
        Document oldDoc = null;
        int n = 0;
        while (true) {
            if (n++ > 13) {
                throw new CouchbaseLiteException("Too many attempts to resolve a conflicted document: " + n, "CouchbaseLite", 10);
            }
            try {
                this.saveInternal(document, oldDoc, false, ConcurrencyControl.FAIL_ON_CONFLICT);
                return;
            }
            catch (CouchbaseLiteException e2) {
                if (!CouchbaseLiteException.isConflict(e2)) {
                    throw e2;
                }
                Object e2 = this.getDbLock();
                synchronized (e2) {
                    oldDoc = Document.getDocument((Database)this, document.getId());
                }
                try {
                    if (handler.handle(document, oldDoc.isDeleted() ? null : oldDoc)) continue;
                    throw new CouchbaseLiteException("Conflict handler returned false", "CouchbaseLite", 8);
                }
                catch (Exception e22) {
                    throw new CouchbaseLiteException("Conflict handler threw an exception", e22, "CouchbaseLite", 8);
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInternal(@NonNull Document document, @Nullable Document baseDoc, boolean deleting, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        Preconditions.assertNotNull(concurrencyControl, "concurrencyControl");
        if (deleting && !document.exists()) {
            throw new CouchbaseLiteException("DeleteDocFailedNotSaved", "CouchbaseLite", 7);
        }
        Object object = this.getDbLock();
        synchronized (object) {
            this.prepareDocument(document);
            boolean commit = false;
            this.beginTransaction();
            try {
                this.saveInTransaction(document, baseDoc == null ? null : baseDoc.getC4doc(), deleting);
                commit = true;
                return;
            }
            catch (CouchbaseLiteException e) {
                if (!CouchbaseLiteException.isConflict(e)) {
                    throw e;
                }
                if (concurrencyControl.equals((Object)ConcurrencyControl.FAIL_ON_CONFLICT)) {
                    throw new CouchbaseLiteException("Conflict", "CouchbaseLite", 8);
                }
                commit = this.saveConflicted(document, deleting);
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    @GuardedBy(value="getDbLock()")
    private boolean saveConflicted(@NonNull Document document, boolean deleting) throws CouchbaseLiteException {
        C4Document curDoc;
        try {
            curDoc = this.getC4Document(document.getId());
        }
        catch (LiteCoreException e) {
            if (deleting && e.domain == 1 && e.code == 7) {
                return false;
            }
            throw CouchbaseLiteException.convertException(e);
        }
        if (deleting && curDoc.deleted()) {
            document.replaceC4Document(curDoc);
            return false;
        }
        this.saveInTransaction(document, curDoc, deleting);
        return true;
    }

    @GuardedBy(value="getDbLock()")
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private void saveInTransaction(@NonNull Document document, @Nullable C4Document base, boolean deleting) throws CouchbaseLiteException {
        try (FLSliceResult body = null;){
            int revFlags = 0;
            if (deleting) {
                revFlags = 1;
            } else if (!document.isEmpty() && C4Document.dictContainsBlobs(body = document.encode(), this.sharedKeys.getFLSharedKeys())) {
                revFlags |= 8;
            }
            C4Document c4Doc = base != null ? base : document.getC4doc();
            c4Doc = c4Doc != null ? c4Doc.update(body, revFlags) : this.getOpenC4DbLocked().create(document.getId(), body, revFlags);
            document.replaceC4Document(c4Doc);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void purgeLocked(@NonNull String id) throws CouchbaseLiteException {
        boolean commit = false;
        this.beginTransaction();
        try {
            this.getOpenC4DbLocked().purgeDoc(id);
            commit = true;
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        finally {
            this.endTransaction(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyActiveProcesses() {
        int activeProcessCount;
        HashSet processes;
        HashSet<ActiveProcess> deadProcesses = new HashSet<ActiveProcess>();
        Set<ActiveProcess<?>> set = this.activeProcesses;
        synchronized (set) {
            processes = new HashSet(this.activeProcesses);
        }
        for (ActiveProcess set2 : processes) {
            if (set2.isActive()) continue;
            com.couchbase.lite.internal.support.Log.w(DOMAIN, "Found dead process: " + set2);
            deadProcesses.add(set2);
        }
        if (!deadProcesses.isEmpty()) {
            set = this.activeProcesses;
            synchronized (set) {
                this.activeProcesses.removeAll(deadProcesses);
            }
        }
        if (this.closeLatch == null) {
            return;
        }
        Set<ActiveProcess<?>> set2 = this.activeProcesses;
        synchronized (set2) {
            activeProcessCount = this.activeProcesses.size();
        }
        com.couchbase.lite.internal.support.Log.d(DOMAIN, "Active processes(%s): %d", this.getName(), activeProcessCount);
        if (activeProcessCount <= 0) {
            this.closeLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean failIfClosed, Fn.ConsumerThrows<C4Database, LiteCoreException> onShut) throws CouchbaseLiteException {
        C4Database c4Db;
        Object object = this.getDbLock();
        synchronized (object) {
            if (!failIfClosed && !this.isOpen()) {
                return;
            }
            c4Db = this.getOpenC4DbLocked();
            this.setC4DatabaseLocked(null);
            this.freeC4DbObserver();
            this.docChangeNotifiers.clear();
            this.closeLatch = new CountDownLatch(1);
            HashSet liveProcesses = null;
            Set<ActiveProcess<?>> set = this.activeProcesses;
            synchronized (set) {
                if (!this.activeProcesses.isEmpty()) {
                    liveProcesses = new HashSet(this.activeProcesses);
                }
            }
            this.shutdownActiveProcesses(liveProcesses);
        }
        try {
            int i = 0;
            while (true) {
                this.verifyActiveProcesses();
                if (i >= 5 && this.closeLatch.getCount() > 0L) {
                    throw new CouchbaseLiteException("Shutdown failed", "CouchbaseLite", 16);
                }
                if (!this.closeLatch.await(6L, TimeUnit.SECONDS)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object2 = this.getDbLock();
        synchronized (object2) {
            try {
                onShut.accept(c4Db);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        this.shutdownExecutors(this.postExecutor, this.queryExecutor, 5);
    }

    @GuardedBy(value="getDbLock()")
    private void freeC4DbObserver() {
        C4DatabaseObserver observer = this.c4DbObserver;
        this.c4DbObserver = null;
        if (observer == null) {
            return;
        }
        observer.close();
    }

    private void shutdownActiveProcesses(Collection<ActiveProcess<?>> processes) {
        if (processes == null) {
            return;
        }
        for (ActiveProcess<?> process : processes) {
            process.stop();
        }
    }

    private void shutdownExecutors(ExecutionService.CloseableExecutor pExec, ExecutionService.CloseableExecutor qExec, int waitTime) {
        if (pExec != null) {
            pExec.stop(waitTime, TimeUnit.SECONDS);
        }
        if (qExec != null) {
            qExec.stop(waitTime, TimeUnit.SECONDS);
        }
    }

    private void fixHydrogenBug(@NonNull ImmutableDatabaseConfiguration config, @NonNull String dbName) throws CouchbaseLiteException {
        String defaultDirPath = CouchbaseLiteInternal.getRootDir().getAbsolutePath();
        if (!defaultDirPath.equals(config.getDirectory())) {
            return;
        }
        File defaultDir = new File(defaultDirPath);
        File twoDotEightDefaultDir = new File(defaultDir, ".couchbase");
        if (!AbstractDatabase.exists(dbName, twoDotEightDefaultDir)) {
            return;
        }
        if (AbstractDatabase.exists(dbName, defaultDir)) {
            return;
        }
        File twoDotEightDb = C4Database.getDatabaseFile(twoDotEightDefaultDir, dbName);
        try {
            Database.copy(twoDotEightDb, dbName, config);
        }
        catch (CouchbaseLiteException e) {
            try {
                FileUtils.eraseFileOrDir(C4Database.getDatabaseFile(defaultDir, dbName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    static class ActiveProcess<T> {
        @NonNull
        private final T process;

        ActiveProcess(@NonNull T process) {
            this.process = process;
        }

        public boolean isActive() {
            return true;
        }

        public void stop() {
        }

        @NonNull
        public String toString() {
            return this.process.toString();
        }

        public int hashCode() {
            return this.process.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ActiveProcess)) {
                return false;
            }
            ActiveProcess other = (ActiveProcess)o;
            return this.process.equals(other.process);
        }
    }
}

