/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLDictIterator;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MDict
extends MCollection
implements Iterable<String> {
    private FLDict _dict;
    private Map<String, MValue> _map = new HashMap<String, MValue>();
    private final List<String> _newKey = new ArrayList<String>();
    private long _count = 0L;

    public void initInSlot(MValue mv, MCollection parent) {
        this.initInSlot(mv, parent, parent != null ? parent.getMutableChildren() : false);
    }

    @Override
    protected void initInSlot(MValue mv, MCollection parent, boolean isMutable) {
        super.initInSlot(mv, parent, isMutable);
        if (this._dict != null) {
            throw new IllegalStateException("_dict is not null");
        }
        FLValue value = mv.getValue();
        if (value != null) {
            this._dict = value.asFLDict();
            this._count = this._dict.count();
        } else {
            this._dict = null;
            this._count = 0L;
        }
    }

    public void initAsCopyOf(MDict d, boolean isMutable) {
        super.initAsCopyOf(d, isMutable);
        this._dict = d._dict;
        this._map = new HashMap<String, MValue>(d._map);
        this._count = d._count;
    }

    public long count() {
        return this._count;
    }

    public boolean clear() {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot clear a non-mutable MDict");
        }
        if (this._count == 0L) {
            return true;
        }
        this.mutate();
        this._map.clear();
        if (this._dict != null) {
            FLDictIterator itr = new FLDictIterator();
            try {
                itr.begin(this._dict);
                while (itr.getValue() != null) {
                    String key = itr.getKeyString();
                    this._map.put(key, MValue.EMPTY);
                    if (itr.next()) continue;
                    break;
                }
            }
            finally {
                itr.free();
            }
        }
        this._count = 0L;
        return true;
    }

    public boolean contains(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null.");
        }
        MValue v = this._map.get(key);
        if (v != null) {
            return !v.isEmpty();
        }
        return this._dict != null && this._dict.get(key) != null;
    }

    public MValue get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null.");
        }
        MValue v = this._map.get(key);
        if (v == null) {
            FLValue value = this._dict != null ? this._dict.get(key) : null;
            v = value != null ? this.setInMap(key, new MValue(value)) : MValue.EMPTY;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeys() {
        ArrayList<String> keys;
        block7: {
            keys = new ArrayList<String>();
            for (Map.Entry<String, MValue> entry : this._map.entrySet()) {
                MValue value = entry.getValue();
                if (value.isEmpty()) continue;
                keys.add(entry.getKey());
            }
            if (this._dict != null) {
                FLDictIterator itr = new FLDictIterator();
                try {
                    itr.begin(this._dict);
                    if (itr.getCount() <= 0L) break block7;
                    while (itr.getValue() != null) {
                        String key = itr.getKeyString();
                        if (!this._map.containsKey(key)) {
                            keys.add(key);
                        }
                        if (itr.next()) continue;
                        break;
                    }
                }
                finally {
                    itr.free();
                }
            }
        }
        return keys;
    }

    public boolean remove(String key) {
        return this.set(key, MValue.EMPTY);
    }

    public boolean set(String key, MValue value) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null.");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot set items in a non-mutable MDict");
        }
        MValue oValue = this._map.get(key);
        if (oValue != null) {
            if (value.isEmpty() && oValue.isEmpty()) {
                return true;
            }
            this.mutate();
            this._count += (long)((value.isEmpty() ? 0 : 1) - (oValue.isEmpty() ? 0 : 1));
            this._map.put(key, value);
        } else {
            if (this._dict != null && this._dict.get(key) != null) {
                if (value.isEmpty()) {
                    --this._count;
                }
            } else {
                if (value.isEmpty()) {
                    return true;
                }
                ++this._count;
            }
            this.mutate();
            this.setInMap(key, value);
        }
        return true;
    }

    private MValue setInMap(String key, MValue value) {
        this._newKey.add(key);
        this._map.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeTo(Encoder enc) {
        if (!this.isMutated()) {
            if (this._dict == null) {
                enc.beginDict(0L);
                enc.endDict();
            } else {
                enc.writeValue(this._dict);
            }
        } else {
            enc.beginDict(this._count);
            for (Map.Entry<String, MValue> entry : this._map.entrySet()) {
                MValue value = entry.getValue();
                if (value.isEmpty()) continue;
                enc.writeKey(entry.getKey());
                value.encodeTo(enc);
            }
            if (this._dict != null) {
                FLDictIterator itr = new FLDictIterator();
                try {
                    FLValue value;
                    itr.begin(this._dict);
                    while ((value = itr.getValue()) != null) {
                        String key = itr.getKeyString();
                        if (!this._map.containsKey(key)) {
                            enc.writeKey(key);
                            enc.writeValue(value);
                        }
                        if (itr.next()) continue;
                        break;
                    }
                }
                finally {
                    itr.free();
                }
            }
            enc.endDict();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }
}

