/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.AllocSlice;
import com.couchbase.litecore.fleece.FLArray;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLEncodable;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLValue;
import java.util.List;
import java.util.Map;

public class Encoder {
    long _handle = 0L;
    boolean _managed;
    FLEncoder _flEncoder;

    public Encoder() {
        this(Encoder.init(), false);
    }

    public Encoder(FLEncoder enc) {
        this(Encoder.initWithFLEncoder(enc._handle), false);
        this._flEncoder = enc;
    }

    Encoder(long handle, boolean managed) {
        if (handle == 0L) {
            throw new IllegalArgumentException();
        }
        this._handle = handle;
        this._managed = managed;
    }

    public void free() {
        if (this._handle != 0L && !this._managed) {
            Encoder.free(this._handle);
            this._handle = 0L;
        }
    }

    public void release() {
        if (this._handle != 0L && !this._managed) {
            Encoder.release(this._handle);
            this._handle = 0L;
        }
    }

    public FLEncoder getFLEncoder() {
        if (this._flEncoder == null) {
            this._flEncoder = new FLEncoder(Encoder.getFLEncoder(this._handle), true);
        }
        return this._flEncoder;
    }

    public boolean writeNull() {
        return Encoder.writeNull(this._handle);
    }

    public boolean beginDict(long reserve) {
        return Encoder.beginDict(this._handle, reserve);
    }

    public boolean endDict() {
        return Encoder.endDict(this._handle);
    }

    public boolean beginArray(long reserve) {
        return Encoder.beginArray(this._handle, reserve);
    }

    public boolean endArray() {
        return Encoder.endArray(this._handle);
    }

    public boolean writeKey(String slice) {
        return Encoder.writeKey(this._handle, slice);
    }

    public boolean writeValue(FLValue flValue) {
        return Encoder.writeValue(this._handle, flValue.getHandle());
    }

    public boolean writeValue(FLArray flValue) {
        return Encoder.writeValue(this._handle, flValue.getHandle());
    }

    public boolean writeValue(FLDict flValue) {
        return Encoder.writeValue(this._handle, flValue.getHandle());
    }

    public boolean write(Map map) {
        if (map != null) {
            this.beginDict(map.size());
            for (String key : map.keySet()) {
                this.writeKey(key);
                this.writeObject(map.get(key));
            }
        } else {
            this.beginDict(0L);
        }
        return this.endDict();
    }

    public boolean write(List list) {
        if (list != null) {
            this.beginArray(list.size());
            for (Object item : list) {
                this.writeObject(item);
            }
        } else {
            this.beginArray(0L);
        }
        return this.endArray();
    }

    public boolean writeObject(Object value) {
        if (value == null) {
            return Encoder.writeNull(this._handle);
        }
        if (value instanceof Boolean) {
            return Encoder.writeBool(this._handle, (Boolean)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return Encoder.writeInt(this._handle, ((Integer)value).longValue());
            }
            if (value instanceof Long) {
                return Encoder.writeInt(this._handle, (Long)value);
            }
            if (value instanceof Short) {
                return Encoder.writeInt(this._handle, ((Short)value).longValue());
            }
            if (value instanceof Double) {
                return Encoder.writeDouble(this._handle, (Double)value);
            }
            return Encoder.writeFloat(this._handle, ((Float)value).floatValue());
        }
        if (value instanceof String) {
            return Encoder.writeString(this._handle, (String)value);
        }
        if (value instanceof byte[]) {
            return Encoder.writeData(this._handle, (byte[])value);
        }
        if (value instanceof List) {
            return this.write((List)value);
        }
        if (value instanceof Map) {
            return this.write((Map)value);
        }
        if (value instanceof FLEncodable) {
            ((FLEncodable)value).encodeTo(this.getFLEncoder());
            return true;
        }
        return false;
    }

    public AllocSlice finish() throws LiteCoreException {
        return new AllocSlice(Encoder.finish(this._handle), false);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native long init();

    static native long initWithFLEncoder(long var0);

    static native void free(long var0);

    static native void release(long var0);

    static native long getFLEncoder(long var0);

    static native boolean writeNull(long var0);

    static native boolean writeBool(long var0, boolean var2);

    static native boolean writeInt(long var0, long var2);

    static native boolean writeFloat(long var0, float var2);

    static native boolean writeDouble(long var0, double var2);

    static native boolean writeString(long var0, String var2);

    static native boolean writeData(long var0, byte[] var2);

    static native boolean writeValue(long var0, long var2);

    static native boolean beginArray(long var0, long var2);

    static native boolean endArray(long var0);

    static native boolean beginDict(long var0, long var2);

    static native boolean writeKey(long var0, String var2);

    static native boolean endDict(long var0);

    static native long finish(long var0);
}

