/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.lite.Database;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import java.util.HashMap;
import java.util.concurrent.Executors;

public class C4Log {
    private static LogLevel CurrentLevel = LogLevel.WARNING;
    private static HashMap<String, LogDomain> DomainObjects = new HashMap();

    public static native void setLevel(String var0, int var1);

    public static native void log(String var0, int var1, String var2);

    public static native int getBinaryFileLevel();

    public static native void setBinaryFileLevel(int var0);

    public static native void writeToBinaryFile(String var0, int var1, int var2, long var3, boolean var5, String var6);

    public static native void setCallbackLevel(int var0);

    static void logCallback(String domainName, int level, String message) {
        C4Log.recalculateLevels();
        LogDomain domain = LogDomain.DATABASE;
        if (DomainObjects.containsKey(domainName)) {
            domain = DomainObjects.get(domainName);
        }
        Database.log.getConsole().log(LogLevel.values()[level], domain, message);
        Logger customLogger = Database.log.getCustom();
        if (customLogger != null) {
            customLogger.log(LogLevel.values()[level], domain, message);
        }
    }

    private static void recalculateLevels() {
        LogLevel callbackLevel = Database.log.getConsole().getLevel();
        Logger customLogger = Database.log.getCustom();
        if (customLogger != null && customLogger.getLevel().compareTo(callbackLevel) < 0) {
            callbackLevel = customLogger.getLevel();
        }
        if (CurrentLevel == callbackLevel) {
            return;
        }
        CurrentLevel = callbackLevel;
        final LogLevel finalLevel = callbackLevel;
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                C4Log.setCallbackLevel(finalLevel.getValue());
            }
        });
    }

    static {
        DomainObjects.put("DB", LogDomain.DATABASE);
        DomainObjects.put("Query", LogDomain.QUERY);
        DomainObjects.put("Sync", LogDomain.REPLICATOR);
        DomainObjects.put("SyncBusy", LogDomain.REPLICATOR);
        DomainObjects.put("BLIP", LogDomain.NETWORK);
        DomainObjects.put("WS", LogDomain.NETWORK);
    }
}

