/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4Database;
import com.couchbase.litecore.C4ListenerConfig;
import com.couchbase.litecore.LiteCoreException;

public class C4Listener {
    private long handle = 0L;

    public static int getAvailableAPIs() {
        return C4Listener.availableAPIs();
    }

    public static String getURINameFromPath(String path) {
        return C4Listener.uriNameFromPath(path);
    }

    public C4Listener(C4ListenerConfig config) throws LiteCoreException {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.handle = C4Listener.start(config.getPort(), config.getApis(), config.getDirectory(), config.isAllowCreateDBs(), config.isAllowDeleteDBs(), config.isAllowPush(), config.isAllowPull());
    }

    public void free() {
        if (this.handle != 0L) {
            C4Listener.free(this.handle);
            this.handle = 0L;
        }
    }

    public boolean shareDB(String name, C4Database db) {
        return C4Listener.shareDB(this.handle, name, db.getHandle());
    }

    public boolean unshareDB(String name) {
        return C4Listener.unshareDB(this.handle, name);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native int availableAPIs();

    static native long start(int var0, int var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6) throws LiteCoreException;

    static native void free(long var0);

    static native boolean shareDB(long var0, String var2, long var3);

    static native boolean unshareDB(long var0, String var2);

    static native String uriNameFromPath(String var0);
}

