/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4Constants;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.RefCounted;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLSharedKeys;
import com.couchbase.litecore.fleece.FLSliceResult;

public class C4Document
extends RefCounted
implements C4Constants {
    private long _handle = 0L;

    C4Document(long db, String docID, boolean mustExist) throws LiteCoreException {
        this(C4Document.get(db, docID, mustExist));
    }

    C4Document(long db, long sequence) throws LiteCoreException {
        this(C4Document.getBySequence(db, sequence));
    }

    C4Document(long handle) {
        if (handle == 0L) {
            throw new IllegalArgumentException("handle is 0");
        }
        this._handle = handle;
    }

    @Override
    void free() {
        if (this._handle != 0L) {
            C4Document.free(this._handle);
            this._handle = 0L;
        }
    }

    public int getFlags() {
        return C4Document.getFlags(this._handle);
    }

    public String getDocID() {
        return C4Document.getDocID(this._handle);
    }

    public String getRevID() {
        return C4Document.getRevID(this._handle);
    }

    public long getSequence() {
        return C4Document.getSequence(this._handle);
    }

    public String getSelectedRevID() {
        return C4Document.getSelectedRevID(this._handle);
    }

    public int getSelectedFlags() {
        return C4Document.getSelectedFlags(this._handle);
    }

    public long getSelectedSequence() {
        return C4Document.getSelectedSequence(this._handle);
    }

    public byte[] getSelectedBody() {
        return C4Document.getSelectedBody(this._handle);
    }

    public FLDict getSelectedBody2() {
        long value = C4Document.getSelectedBody2(this._handle);
        return value == 0L ? null : new FLDict(value);
    }

    public void save(int maxRevTreeDepth) throws LiteCoreException {
        C4Document.save(this._handle, maxRevTreeDepth);
    }

    public boolean selectCurrentRevision() {
        return C4Document.selectCurrentRevision(this._handle);
    }

    public void loadRevisionBody() throws LiteCoreException {
        C4Document.loadRevisionBody(this._handle);
    }

    public boolean hasRevisionBody() {
        return C4Document.hasRevisionBody(this._handle);
    }

    public boolean selectParentRevision() {
        return C4Document.selectParentRevision(this._handle);
    }

    public boolean selectNextRevision() {
        return C4Document.selectNextRevision(this._handle);
    }

    public void selectNextLeafRevision(boolean includeDeleted, boolean withBody) throws LiteCoreException {
        C4Document.selectNextLeafRevision(this._handle, includeDeleted, withBody);
    }

    public boolean selectFirstPossibleAncestorOf(String revID) throws LiteCoreException {
        return C4Document.selectFirstPossibleAncestorOf(this._handle, revID);
    }

    public boolean selectNextPossibleAncestorOf(String revID) {
        return C4Document.selectNextPossibleAncestorOf(this._handle, revID);
    }

    public boolean selectCommonAncestorRevision(String revID1, String revID2) {
        return C4Document.selectCommonAncestorRevision(this._handle, revID1, revID2);
    }

    public int purgeRevision(String revID) throws LiteCoreException {
        return C4Document.purgeRevision(this._handle, revID);
    }

    public void resolveConflict(String winningRevID, String losingRevID, byte[] mergeBody, int mergedFlags) throws LiteCoreException {
        C4Document.resolveConflict(this._handle, winningRevID, losingRevID, mergeBody, mergedFlags);
    }

    public C4Document update(byte[] body, int flags) throws LiteCoreException {
        return new C4Document(C4Document.update(this._handle, body, flags));
    }

    public C4Document update(FLSliceResult body, int flags) throws LiteCoreException {
        return new C4Document(C4Document.update2(this._handle, body != null ? body.getHandle() : 0L, flags));
    }

    public boolean deleted() {
        return this.isSelectedRevFlags(1);
    }

    public boolean accessRemoved() {
        return this.isSelectedRevFlags(128);
    }

    public boolean conflicted() {
        return this.isFlags(2);
    }

    public boolean exists() {
        return this.isFlags(4096);
    }

    private boolean isFlags(int flag) {
        return (C4Document.getFlags(this._handle) & flag) == flag;
    }

    public boolean isSelectedRevFlags(int flag) {
        return (C4Document.getSelectedFlags(this._handle) & flag) == flag;
    }

    public static boolean dictContainsBlobs(FLSliceResult dict, FLSharedKeys sk) {
        return C4Document.dictContainsBlobs(dict.getHandle(), sk.getHandle());
    }

    public String bodyAsJSON(boolean canonical) throws LiteCoreException {
        return C4Document.bodyAsJSON(this._handle, canonical);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native int getFlags(long var0);

    static native String getDocID(long var0);

    static native String getRevID(long var0);

    static native long getSequence(long var0);

    static native String getSelectedRevID(long var0);

    static native int getSelectedFlags(long var0);

    static native long getSelectedSequence(long var0);

    static native byte[] getSelectedBody(long var0);

    static native long getSelectedBody2(long var0);

    static native long get(long var0, String var2, boolean var3) throws LiteCoreException;

    static native long getBySequence(long var0, long var2) throws LiteCoreException;

    static native void save(long var0, int var2) throws LiteCoreException;

    static native void free(long var0);

    static native boolean selectCurrentRevision(long var0);

    static native void loadRevisionBody(long var0) throws LiteCoreException;

    static native boolean hasRevisionBody(long var0);

    static native boolean selectParentRevision(long var0);

    static native boolean selectNextRevision(long var0);

    static native void selectNextLeafRevision(long var0, boolean var2, boolean var3) throws LiteCoreException;

    static native boolean selectFirstPossibleAncestorOf(long var0, String var2);

    static native boolean selectNextPossibleAncestorOf(long var0, String var2);

    static native boolean selectCommonAncestorRevision(long var0, String var2, String var3);

    static native int purgeRevision(long var0, String var2) throws LiteCoreException;

    static native void resolveConflict(long var0, String var2, String var3, byte[] var4, int var5) throws LiteCoreException;

    static native void setExpiration(long var0, String var2, long var3) throws LiteCoreException;

    static native long getExpiration(long var0, String var2);

    static native long put(long var0, byte[] var2, String var3, int var4, boolean var5, boolean var6, String[] var7, boolean var8, int var9, int var10) throws LiteCoreException;

    static native long put2(long var0, long var2, String var4, int var5, boolean var6, boolean var7, String[] var8, boolean var9, int var10, int var11) throws LiteCoreException;

    static native long create(long var0, String var2, byte[] var3, int var4) throws LiteCoreException;

    static native long create2(long var0, String var2, long var3, int var5) throws LiteCoreException;

    static native long update(long var0, byte[] var2, int var3) throws LiteCoreException;

    static native long update2(long var0, long var2, int var4) throws LiteCoreException;

    static native boolean dictContainsBlobs(long var0, long var2);

    static native String bodyAsJSON(long var0, boolean var2) throws LiteCoreException;
}

