/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JSONObject toJson(Map<String, Object> map) throws JSONException {
        if (map == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) {
                json.put(key, JSONObject.NULL);
                continue;
            }
            if (value instanceof Map) {
                json.put(key, (Object)JsonUtils.toJson((Map)value));
                continue;
            }
            if (value instanceof List) {
                json.put(key, (Object)JsonUtils.toJson((List)value));
                continue;
            }
            json.put(key, value);
        }
        return json;
    }

    public static JSONArray toJson(List<Object> list) throws JSONException {
        if (list == null) {
            return null;
        }
        JSONArray json = new JSONArray();
        for (Object value : list) {
            if (value == null) {
                json.put(JSONObject.NULL);
                continue;
            }
            if (value instanceof Map) {
                json.put((Object)JsonUtils.toJson((Map)value));
                continue;
            }
            if (value instanceof List) {
                json.put((Object)JsonUtils.toJson((List)value));
                continue;
            }
            json.put(value);
        }
        return json;
    }

    public static Map<String, Object> fromJson(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = json.get(key);
            if (value instanceof JSONObject) {
                result.put(key, JsonUtils.fromJson((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                result.put(key, JsonUtils.fromJson((JSONArray)value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static List<Object> fromJson(JSONArray json) throws JSONException {
        if (json == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            Object value = json.get(i);
            if (value instanceof JSONObject) {
                result.add(JsonUtils.fromJson((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                result.add(JsonUtils.fromJson((JSONArray)value));
                continue;
            }
            result.add(value);
        }
        return result;
    }
}

