/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorUtils {
    private ExecutorUtils() {
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, int waitSec) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
                    Log.e(LogDomain.DATABASE, "Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

