/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.From;
import com.couchbase.lite.FromRouter;
import com.couchbase.lite.SelectResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Select
extends AbstractQuery
implements FromRouter {
    private boolean distinct;
    private List<SelectResult> selectResults;

    Select(boolean distinct, SelectResult ... selectResults) {
        this.distinct = distinct;
        this.selectResults = Arrays.asList(selectResults);
        this.setSelect(this);
    }

    @Override
    @NonNull
    public From from(@NonNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null.");
        }
        return new From(this, dataSource);
    }

    List<SelectResult> getSelectResults() {
        return this.selectResults;
    }

    boolean isDistinct() {
        return this.distinct;
    }

    boolean hasSelectResults() {
        return this.selectResults.size() > 0;
    }

    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (SelectResult sr : this.selectResults) {
            json.add(sr.asJSON());
        }
        return json;
    }
}

