/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.Result;
import com.couchbase.lite.ResultContext;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4QueryEnumerator;
import com.couchbase.litecore.LiteCoreException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResultSet
implements Iterable<Result> {
    private static final LogDomain DOMAIN = LogDomain.QUERY;
    private AbstractQuery query;
    private C4QueryEnumerator c4enum;
    private Map<String, Integer> columnNames;
    private ResultContext context;
    private boolean isAllEnumerated;

    ResultSet(AbstractQuery query, C4QueryEnumerator c4enum, Map<String, Integer> columnNames) {
        this.query = query;
        this.c4enum = c4enum;
        this.columnNames = columnNames;
        this.context = new ResultContext(query.getDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result next() {
        if (this.query == null) {
            throw new IllegalStateException("_query variable is null");
        }
        Object object = this.getDatabase().getLock();
        synchronized (object) {
            try {
                if (this.c4enum == null) {
                    return null;
                }
                if (this.isAllEnumerated) {
                    Log.w(DOMAIN, "All query results have already been enumerated.");
                    return null;
                }
                if (!this.c4enum.next()) {
                    Log.i(DOMAIN, "End of query enumeration");
                    this.isAllEnumerated = true;
                    return null;
                }
                return this.currentObject();
            }
            catch (LiteCoreException e) {
                Log.w(DOMAIN, "Query enumeration error: %s", e.toString());
                return null;
            }
        }
    }

    @NonNull
    public List<Result> allResults() {
        Result result;
        ArrayList<Result> results = new ArrayList<Result>();
        while ((result = this.next()) != null) {
            results.add(result);
        }
        return results;
    }

    @Override
    @NonNull
    public Iterator<Result> iterator() {
        return this.allResults().iterator();
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free() {
        if (this.c4enum != null) {
            Object object = this.getDatabase().getLock();
            synchronized (object) {
                this.c4enum.close();
            }
            this.c4enum.free();
            this.c4enum = null;
        }
    }

    ResultSet refresh() throws CouchbaseLiteException {
        if (this.query == null) {
            throw new IllegalStateException("_query variable is null");
        }
        Object object = this.getDatabase().getLock();
        synchronized (object) {
            try {
                C4QueryEnumerator newEnum = this.c4enum.refresh();
                return newEnum != null ? new ResultSet(this.query, newEnum, this.columnNames) : null;
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    int columnCount() {
        return this.columnNames.size();
    }

    Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }

    AbstractQuery getQuery() {
        return this.query;
    }

    private Database getDatabase() {
        return this.query.getDatabase();
    }

    private Result currentObject() {
        return new Result(this, this.c4enum, this.context);
    }
}

