/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.DefaultExecutor;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import java.util.concurrent.Executor;

final class ReplicatorChangeListenerToken
implements ListenerToken {
    private Executor executor;
    private final ReplicatorChangeListener listener;

    ReplicatorChangeListenerToken(Executor executor, ReplicatorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("a listener parameter is null");
        }
        this.executor = executor;
        this.listener = listener;
    }

    void notify(final ReplicatorChange change) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ReplicatorChangeListenerToken.this.listener.changed(change);
            }
        });
    }

    Executor getExecutor() {
        return this.executor != null ? this.executor : DefaultExecutor.instance();
    }
}

