/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.Expression;
import com.couchbase.lite.IndexType;
import java.util.ArrayList;
import java.util.List;

public class PredictiveIndex
extends AbstractIndex {
    private String model;
    private Expression input;
    private List<String> properties;

    PredictiveIndex(@NonNull String model, @NonNull Expression input, List<String> properties) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null.");
        }
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.model = model;
        this.input = input;
        this.properties = properties;
    }

    @Override
    IndexType type() {
        return IndexType.Predictive;
    }

    @Override
    String language() {
        return null;
    }

    @Override
    boolean ignoreAccents() {
        return false;
    }

    @Override
    List<Object> items() {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add("PREDICTION()");
        items.add(this.model);
        items.add(this.input.asJSON());
        if (this.properties != null) {
            for (String property : this.properties) {
                items.add("." + property);
            }
        }
        ArrayList<Object> json = new ArrayList<Object>();
        json.add(items);
        return json;
    }
}

