/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Database;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.PredictiveModel;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4Database;
import com.couchbase.litecore.C4Prediction;
import com.couchbase.litecore.C4PredictiveModel;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLSliceResult;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MRoot;
import java.util.HashMap;
import java.util.Map;

public final class Prediction {
    private Map<String, Object> models;

    public synchronized void registerModel(@NonNull String name, @NonNull PredictiveModel model) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null.");
        }
        if (this.models == null) {
            this.models = new HashMap<String, Object>();
        }
        if (this.models.containsKey(name)) {
            C4Prediction.unregister(name);
        }
        C4PredictiveModelImpl c4Model = new C4PredictiveModelImpl(model);
        C4Prediction.register(name, c4Model);
        this.models.put(name, c4Model);
    }

    public synchronized void unregisterModel(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (this.models == null) {
            return;
        }
        C4Prediction.unregister(name);
        this.models.remove(name);
    }

    Prediction() {
    }

    private class C4PredictiveModelImpl
    implements C4PredictiveModel {
        private PredictiveModel model;

        C4PredictiveModelImpl(PredictiveModel model) {
            this.model = model;
        }

        @Override
        public long predict(long input, long c4db) {
            DocContext context = new DocContext(new Database(new C4Database(c4db).retain()), null);
            MRoot root = new MRoot(context, new FLValue(input), false);
            Dictionary dict = (Dictionary)root.asNative();
            Dictionary output = this.model.predict(dict);
            return this.encode(output).getHandle();
        }

        private FLSliceResult encode(Dictionary prediction) {
            if (prediction != null) {
                FLEncoder encoder = new FLEncoder();
                prediction.encodeTo(encoder);
                try {
                    return encoder.finish2().retain();
                }
                catch (LiteCoreException e) {
                    Log.e(LogDomain.QUERY, "Error when encoding a predictive result", e);
                }
            }
            return new FLSliceResult().retain();
        }
    }
}

