/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Message;
import com.couchbase.lite.MessageEndpoint;
import com.couchbase.lite.MessageEndpointConnection;
import com.couchbase.lite.MessagingCloseCompletion;
import com.couchbase.lite.MessagingCompletion;
import com.couchbase.lite.MessagingError;
import com.couchbase.lite.ProtocolType;
import com.couchbase.lite.ReplicatorConnection;
import com.couchbase.litecore.C4Socket;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

class MessageSocket
extends C4Socket
implements ReplicatorConnection {
    private ProtocolType protocolType;
    private MessageEndpointConnection connection;
    private boolean sendResponseStatus;
    private boolean closed;
    private ScheduledExecutorService executor;

    public MessageSocket(long handle, MessageEndpoint endpoint, Map<String, Object> options) {
        this.init(handle, endpoint.getDelegate().createConnection(endpoint), endpoint.getProtocolType());
    }

    public MessageSocket(MessageEndpointConnection connection, ProtocolType protocolType) {
        C4Socket.socketFactory.put(this, MessageSocket.class);
        String path = String.format(Locale.ENGLISH, "/%s", Integer.toHexString(connection.hashCode()));
        int framing = 1;
        if (protocolType == ProtocolType.BYTE_STREAM) {
            framing = 0;
        }
        long handle = C4Socket.fromNative(this, "x-msg-conn", "", 0, path, framing);
        this.init(handle, connection, protocolType);
    }

    private void init(long handle, MessageEndpointConnection connection, ProtocolType protocolType) {
        this.handle = handle;
        this.connection = connection;
        this.protocolType = protocolType;
        this.nativeHandle = this;
        this.closed = false;
        this.sendResponseStatus = true;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable target) {
                return new Thread(target, "MessageSocket");
            }
        });
        C4Socket.reverseLookupTable.put(this.handle, this);
    }

    @Override
    protected void send(byte[] allocatedData) {
        final int length = allocatedData.length;
        this.connection.send(Message.fromData(allocatedData), new MessagingCompletion(){

            @Override
            public void complete(boolean success, MessagingError error) {
                if (success) {
                    MessageSocket.this.messageSent(length);
                } else {
                    MessageSocket.this.close(error);
                }
            }
        });
    }

    @Override
    protected void completedReceive(long byteCount) {
    }

    @Override
    protected void close() {
        this.connection.close(null, new MessagingCloseCompletion(){

            @Override
            public void complete() {
                MessageSocket.this.connectionClosed(null);
            }
        });
    }

    @Override
    protected void requestClose(final int status, String message) {
        final CouchbaseLiteException error = status != 1000 ? CBLStatus.convertException(6, status, message, null) : null;
        this.connection.close(error, new MessagingCloseCompletion(){

            @Override
            public void complete() {
                MessagingError messagingError = null;
                if (error != null) {
                    messagingError = new MessagingError(error, status == 4001);
                }
                MessageSocket.this.connectionClosed(messagingError);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final MessagingError error) {
        MessageSocket messageSocket = this;
        synchronized (messageSocket) {
            if (this.handle == 0L || this.closed) {
                return;
            }
            if (this.protocolType == ProtocolType.MESSAGE_STREAM) {
                int status = this.getStatusCode(error);
                String message = error != null ? error.getError().getMessage() : "";
                MessageSocket.closeRequested(this.handle, status, message);
            }
        }
        if (this.protocolType == ProtocolType.BYTE_STREAM) {
            this.connection.close(error != null ? error.getError() : null, new MessagingCloseCompletion(){

                @Override
                public void complete() {
                    MessageSocket.this.connectionClosed(error);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) {
        MessageSocket messageSocket = this;
        synchronized (messageSocket) {
            if (message == null) {
                throw new IllegalArgumentException("message cannot be null.");
            }
            if (this.handle == 0L || this.closed) {
                return;
            }
            MessageSocket.received(this.handle, message.toData());
        }
    }

    public static void socket_open(long socket, Object socketFactoryContext, String scheme, String hostname, int port, String path, byte[] optionsFleece) {
        final MessageSocket messageSocket = (MessageSocket)C4Socket.reverseLookupTable.get(socket);
        messageSocket.connection.open(messageSocket, new MessagingCompletion(){

            @Override
            public void complete(boolean success, MessagingError error) {
                if (success) {
                    messageSocket.connectionOpened();
                } else {
                    messageSocket.connectionClosed(error);
                }
            }
        });
    }

    MessageEndpointConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionOpened() {
        MessageSocket messageSocket = this;
        synchronized (messageSocket) {
            if (this.handle == 0L) {
                return;
            }
            if (this.sendResponseStatus) {
                this.connectionGotResponse(200, null);
            }
            MessageSocket.opened(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(MessagingError error) {
        MessageSocket messageSocket = this;
        synchronized (messageSocket) {
            if (this.handle == 0L || this.closed) {
                return;
            }
            this.closed = true;
            final int domain = error != null ? 6 : 0;
            final int code = error != null ? this.getStatusCode(error) : 0;
            final String message = error != null ? error.getError().getMessage() : "";
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageSocket.closed(MessageSocket.this.handle, domain, code, message);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageSent(int byteCount) {
        MessageSocket messageSocket = this;
        synchronized (messageSocket) {
            if (this.handle == 0L || this.closed) {
                return;
            }
            this.completedWrite(byteCount);
        }
    }

    private void connectionGotResponse(int httpStatus, Map headers) {
        if (this.handle == 0L) {
            return;
        }
        MessageSocket.gotHTTPResponse(this.handle, httpStatus, null);
        this.sendResponseStatus = false;
    }

    private int getStatusCode(MessagingError error) {
        if (error == null) {
            return 1000;
        }
        return error.isRecoverable() ? 4001 : 4002;
    }
}

