/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLConstants;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;
import java.util.concurrent.atomic.AtomicBoolean;

final class MValueDelegate
implements MValue.Delegate,
FLConstants.FLValueType {
    MValueDelegate() {
    }

    @Override
    public Object toNative(MValue mv, MCollection parent, AtomicBoolean cacheIt) {
        FLValue value = mv.getValue();
        int type = value.getType();
        switch (type) {
            case 5: {
                cacheIt.set(true);
                return MValueDelegate.mValueToArray(mv, parent);
            }
            case 6: {
                cacheIt.set(true);
                return MValueDelegate.mValueToDictionary(mv, parent);
            }
            case 4: {
                return new Blob("application/octet-stream", value.asData());
            }
        }
        return value.asObject();
    }

    private static Object mValueToArray(MValue mv, MCollection parent) {
        if (parent != null && parent.getMutableChildren()) {
            return new MutableArray(mv, parent);
        }
        return new Array(mv, parent);
    }

    static Object createSpecialObjectOfType(String type, FLDict properties, DocContext context) {
        if ("blob".equals(type)) {
            return MValueDelegate.createBlob(properties, context);
        }
        return null;
    }

    static Object createBlob(FLDict properties, DocContext context) {
        return new Blob(context.getDatabase(), properties.asDict());
    }

    static boolean isOldAttachment(FLDict flDict) {
        FLValue flDigest = flDict.get("digest");
        FLValue flLength = flDict.get("length");
        FLValue flStub = flDict.get("stub");
        FLValue flRevPos = flDict.get("revpos");
        return flDigest != null && flLength != null && flStub != null && flRevPos != null;
    }

    private static Object mValueToDictionary(MValue mv, MCollection parent) {
        String type;
        FLValue value = mv.getValue();
        FLDict flDict = value.asFLDict();
        DocContext context = (DocContext)parent.getContext();
        FLValue flType = flDict.get("@type");
        String string = type = flType != null ? flType.asString() : null;
        if (type != null) {
            Object obj = MValueDelegate.createSpecialObjectOfType(type, flDict, context);
            if (obj != null) {
                return obj;
            }
        } else if (MValueDelegate.isOldAttachment(flDict)) {
            return MValueDelegate.createBlob(flDict, context);
        }
        if (parent != null && parent.getMutableChildren()) {
            return new MutableDictionary(mv, parent);
        }
        return new Dictionary(mv, parent);
    }

    @Override
    public MCollection collectionFromNative(Object object) {
        if (object instanceof Array) {
            return ((Array)object).toMCollection();
        }
        if (object instanceof Dictionary) {
            return ((Dictionary)object).toMCollection();
        }
        return null;
    }

    @Override
    public void encodeNative(Encoder enc, Object object) {
        if (object == null) {
            enc.writeNull();
        } else {
            enc.writeObject(object);
        }
    }
}

