/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.FullTextIndexItem;
import com.couchbase.lite.IndexType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class FullTextIndex
extends AbstractIndex {
    private List<FullTextIndexItem> indexItems;
    private String language = FullTextIndex.getDefaultLanguage();
    private boolean ignoreAccents = false;

    FullTextIndex(FullTextIndexItem ... indexItems) {
        this.indexItems = Arrays.asList(indexItems);
    }

    @NonNull
    public FullTextIndex setLanguage(String language) {
        this.language = language;
        return this;
    }

    @NonNull
    public FullTextIndex ignoreAccents(boolean ignoreAccents) {
        this.ignoreAccents = ignoreAccents;
        return this;
    }

    @Override
    IndexType type() {
        return IndexType.FullText;
    }

    @Override
    String language() {
        return this.language;
    }

    @Override
    boolean ignoreAccents() {
        return this.ignoreAccents;
    }

    @Override
    List<Object> items() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (FullTextIndexItem item : this.indexItems) {
            items.add(item.expression.asJSON());
        }
        return items;
    }

    private static String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }
}

