/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.CBLError;
import java.util.Map;

public final class CouchbaseLiteException
extends Exception
implements CBLError.Domain {
    private final String domain;
    private final int code;
    private final Map<String, Object> info;

    public CouchbaseLiteException(String message) {
        super(message);
        this.domain = "CouchbaseLite";
        this.code = 0;
        this.info = null;
    }

    public CouchbaseLiteException(Throwable cause) {
        super(cause);
        this.domain = "CouchbaseLite";
        this.code = 0;
        this.info = null;
    }

    public CouchbaseLiteException(@NonNull String domain, int code) {
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        this.domain = domain;
        this.code = code;
        this.info = null;
    }

    public CouchbaseLiteException(String message, @NonNull String domain, int code) {
        super(message);
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        this.domain = domain;
        this.code = code;
        this.info = null;
    }

    public CouchbaseLiteException(@NonNull String domain, int code, Throwable cause) {
        super(cause);
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        this.domain = domain;
        this.code = code;
        this.info = null;
    }

    public CouchbaseLiteException(@NonNull String message, Throwable cause, String domain, int code) {
        super(message, cause);
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        this.domain = domain;
        this.code = code;
        this.info = null;
    }

    public CouchbaseLiteException(@NonNull String domain, int code, Map<String, Object> info) {
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        this.domain = domain;
        this.code = code;
        this.info = info;
    }

    @NonNull
    public String getDomain() {
        return this.domain;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    @NonNull
    public String toString() {
        return "CouchbaseLiteException{domain='" + this.domain + '\'' + ", code=" + this.code + ", msg=" + super.getMessage() + '}';
    }
}

