/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.ArrayExpression;
import com.couchbase.lite.Expression;
import com.couchbase.lite.VariableExpression;
import java.util.ArrayList;

public final class ArrayExpressionSatisfies {
    private ArrayExpression.QuantifiesType type;
    private VariableExpression variable;
    private Expression inExpression;

    ArrayExpressionSatisfies(ArrayExpression.QuantifiesType type, VariableExpression variable, Expression inExpression) {
        this.type = type;
        this.variable = variable;
        this.inExpression = inExpression;
    }

    @NonNull
    public Expression satisfies(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new QuantifiedExpression(this.type, this.variable, this.inExpression, expression);
    }

    private static final class QuantifiedExpression
    extends Expression {
        private ArrayExpression.QuantifiesType type;
        private VariableExpression variable;
        private Expression inExpression;
        private Expression satisfiedExpression;

        QuantifiedExpression(ArrayExpression.QuantifiesType type, VariableExpression variable, Expression inExpression, Expression satisfiesExpression) {
            this.type = type;
            this.variable = variable;
            this.inExpression = inExpression;
            this.satisfiedExpression = satisfiesExpression;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>(4);
            switch (this.type) {
                case ANY: {
                    json.add("ANY");
                    break;
                }
                case ANY_AND_EVERY: {
                    json.add("ANY AND EVERY");
                    break;
                }
                case EVERY: {
                    json.add("EVERY");
                }
            }
            json.add(this.variable.getName());
            json.add(this.inExpression.asJSON());
            json.add(this.satisfiedExpression.asJSON());
            return json;
        }
    }
}

