/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.ArrayExpressionIn;
import com.couchbase.lite.VariableExpression;

public final class ArrayExpression {
    private ArrayExpression() {
    }

    @NonNull
    public static ArrayExpressionIn any(@NonNull VariableExpression variable) {
        if (variable == null) {
            throw new IllegalArgumentException("variable cannot be null.");
        }
        return new ArrayExpressionIn(QuantifiesType.ANY, variable);
    }

    @NonNull
    public static ArrayExpressionIn every(@NonNull VariableExpression variable) {
        if (variable == null) {
            throw new IllegalArgumentException("variable cannot be null.");
        }
        return new ArrayExpressionIn(QuantifiesType.EVERY, variable);
    }

    @NonNull
    public static ArrayExpressionIn anyAndEvery(@NonNull VariableExpression variable) {
        if (variable == null) {
            throw new IllegalArgumentException("variable cannot be null.");
        }
        return new ArrayExpressionIn(QuantifiesType.ANY_AND_EVERY, variable);
    }

    @NonNull
    public static VariableExpression variable(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        return new VariableExpression(name);
    }

    static enum QuantifiesType {
        ANY,
        ANY_AND_EVERY,
        EVERY;

    }
}

