/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.content.Context;
import android.support.annotation.NonNull;
import com.couchbase.litecore.C4Base;
import java.io.File;

abstract class AbstractDatabaseConfiguration {
    private static final String TEMP_DIR_NAME = "CouchbaseLiteTemp";
    private static String TEMP_DIR = null;
    private boolean readonly = false;
    private Context context = null;
    private String directory = null;
    private boolean customDir = false;

    protected AbstractDatabaseConfiguration(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        this.readonly = false;
        this.context = context;
        this.directory = context.getFilesDir().getAbsolutePath();
        this.customDir = false;
    }

    protected AbstractDatabaseConfiguration(@NonNull AbstractDatabaseConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.readonly = false;
        this.context = config.context;
        this.directory = config.directory;
        this.customDir = config.customDir;
    }

    @NonNull
    public String getDirectory() {
        return this.directory;
    }

    protected AbstractDatabaseConfiguration setDirectory(@NonNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null.");
        }
        if (this.readonly) {
            throw new IllegalStateException("DatabaseConfiguration is readonly mode.");
        }
        this.directory = directory;
        this.customDir = true;
        return this;
    }

    protected boolean isReadonly() {
        return this.readonly;
    }

    protected void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTempDir() {
        Class<AbstractDatabaseConfiguration> clazz = AbstractDatabaseConfiguration.class;
        synchronized (AbstractDatabaseConfiguration.class) {
            String tempDir = this.tempDir();
            if (!tempDir.equals(TEMP_DIR)) {
                TEMP_DIR = tempDir;
                C4Base.setTempDir(TEMP_DIR);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String tempDir() {
        File temp = null;
        temp = this.customDir ? new File(this.directory, TEMP_DIR_NAME) : new File(this.context.getCacheDir(), TEMP_DIR_NAME);
        if ((temp.exists() || temp.mkdirs()) && temp.isDirectory()) {
            return temp.getAbsolutePath();
        }
        throw new IllegalStateException("Cannot create or access temp directory at " + temp.getAbsolutePath());
    }
}

