//
// Replicator.java
//
// Copyright (c) 2018 Couchbase, Inc.  All rights reserved.
//
// Licensed under the Couchbase License Agreement (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// https://info.couchbase.com/rs/302-GJY-034/images/2017-10-30_License_Agreement.pdf
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package com.couchbase.lite;

import com.couchbase.lite.internal.replicator.CBLWebSocket;
import com.couchbase.litecore.C4Socket;

public final class Replicator extends AbstractReplicator {
    /**
     * Initializes a replicator with the given configuration.
     *
     * @param config
     */
    public Replicator(ReplicatorConfiguration config) {
        super(config);
    }

    @Override
    void initSocketFactory(Object socketFactoryContext) {
        Object target = config.getTarget();
        if (target instanceof MessageEndpoint)
            C4Socket.socketFactory.put(socketFactoryContext, MessageSocketFactory.class);
        else
            C4Socket.socketFactory.put(socketFactoryContext, CBLWebSocket.class);
    }

    @Override
    int framing() {
        Object target = config.getTarget();
        if (target instanceof MessageEndpoint &&
                ((MessageEndpoint)target).getProtocolType() == ProtocolType.BYTE_STREAM)
            return C4Socket.kC4WebSocketClientFraming;
        else
            return C4Socket.kC4NoFraming;
    }

    @Override
    String schema() {
        Object target = config.getTarget();
        if (target instanceof MessageEndpoint)
            return "x-msg-endpt";// put something in the address so it's not illegal
        else
            return null;
    }
}
