//
// DocumentReplicationListener.java
//
// Copyright (c) 2018 Couchbase, Inc All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.couchbase.lite;

import android.support.annotation.NonNull;

/**
 * The listener interface for receiving Document replicated events.
 */
public interface DocumentReplicationListener {
    /**
     * The callback function from Replicator
     *
     * @param replication the Document replicated information
     */
    void replication(@NonNull DocumentReplication replication);
}
