/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv;

import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.kv.ScanResult$;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public class ScanResult
implements Product,
Serializable {
    private final CoreRangeScanItem internal;
    private final Transcoder transcoder;

    public static ScanResult apply(CoreRangeScanItem coreRangeScanItem, Transcoder transcoder) {
        return ScanResult$.MODULE$.apply(coreRangeScanItem, transcoder);
    }

    public static ScanResult fromProduct(Product product) {
        return ScanResult$.MODULE$.fromProduct(product);
    }

    public static ScanResult unapply(ScanResult scanResult) {
        return ScanResult$.MODULE$.unapply(scanResult);
    }

    public ScanResult(CoreRangeScanItem internal, Transcoder transcoder) {
        this.internal = internal;
        this.transcoder = transcoder;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ScanResult)) return false;
        ScanResult scanResult = (ScanResult)object;
        CoreRangeScanItem coreRangeScanItem = this.internal();
        CoreRangeScanItem coreRangeScanItem2 = scanResult.internal();
        if (coreRangeScanItem == null) {
            if (coreRangeScanItem2 != null) {
                return false;
            }
        } else if (!coreRangeScanItem.equals(coreRangeScanItem2)) return false;
        Transcoder transcoder = this.transcoder();
        Transcoder transcoder2 = scanResult.transcoder();
        if (transcoder == null) {
            if (transcoder2 != null) {
                return false;
            }
        } else if (!transcoder.equals(transcoder2)) return false;
        if (!scanResult.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ScanResult;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ScanResult";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "internal";
        }
        if (1 == n2) {
            return "transcoder";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    private CoreRangeScanItem internal() {
        return this.internal;
    }

    public Transcoder transcoder() {
        return this.transcoder;
    }

    public String id() {
        return this.internal().key();
    }

    public boolean idOnly() {
        return this.internal().value().length == 0;
    }

    public Option<Object> cas() {
        long l = this.internal().cas();
        if (0L == l) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.internal().cas()));
    }

    public Option<Instant> expiryTime() {
        return Option$.MODULE$.apply((Object)this.internal().expiry());
    }

    public Option<Duration> expiry() {
        return this.expiryTime().map((Function1 & Serializable)i -> Duration$.MODULE$.apply(i.getEpochSecond(), TimeUnit.SECONDS));
    }

    public <T> Try<T> contentAs(JsonDeserializer<T> deserializer, ClassTag<T> tag) {
        byte[] bytes = this.internal().value();
        int flags = this.internal().flags();
        Transcoder transcoder = this.transcoder();
        if (transcoder instanceof TranscoderWithSerializer) {
            TranscoderWithSerializer t = (TranscoderWithSerializer)transcoder;
            return t.decode(bytes, flags, deserializer, tag);
        }
        if (transcoder instanceof TranscoderWithoutSerializer) {
            TranscoderWithoutSerializer t = (TranscoderWithoutSerializer)transcoder;
            return t.decode(bytes, flags, tag);
        }
        throw new MatchError((Object)transcoder);
    }

    public ScanResult copy(CoreRangeScanItem internal, Transcoder transcoder) {
        return new ScanResult(internal, transcoder);
    }

    public CoreRangeScanItem copy$default$1() {
        return this.internal();
    }

    public Transcoder copy$default$2() {
        return this.transcoder();
    }

    public CoreRangeScanItem _1() {
        return this.internal();
    }

    public Transcoder _2() {
        return this.transcoder();
    }
}

