/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionContext;
import com.couchbase.client.core.transaction.CoreTransactionResult;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarker;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarkerOwner;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.transactions.AsyncTransactionAttemptContext;
import com.couchbase.client.scala.transactions.TransactionAttemptContext;
import com.couchbase.client.scala.transactions.TransactionResult;
import com.couchbase.client.scala.transactions.TransactionResult$;
import com.couchbase.client.scala.transactions.config.TransactionOptions;
import com.couchbase.client.scala.transactions.config.TransactionOptions$;
import com.couchbase.client.scala.transactions.internal.ErrorUtil$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005}3A\u0001C\u0005\u0001)!A!\u0004\u0001BC\u0002\u0013%1\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001d\u0011!)\u0003A!b\u0001\n\u00131\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\r9\u0002A\u0011A\u00060\u0011\u0015!\u0004\u0001\"\u00016\u0011\u001d\u0019\u0006!%A\u0005\u0002Q\u0013A\u0002\u0016:b]N\f7\r^5p]NT!AC\u0006\u0002\u0019Q\u0014\u0018M\\:bGRLwN\\:\u000b\u00051i\u0011!B:dC2\f'B\u0001\b\u0010\u0003\u0019\u0019G.[3oi*\u0011\u0001#E\u0001\nG>,8\r\u001b2bg\u0016T\u0011AE\u0001\u0004G>l7\u0001A\n\u0003\u0001U\u0001\"A\u0006\r\u000e\u0003]Q\u0011\u0001D\u0005\u00033]\u0011a!\u00118z%\u00164\u0017\u0001C5oi\u0016\u0014h.\u00197\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003C5\tAaY8sK&\u00111E\b\u0002\u0019\u0007>\u0014X\r\u0016:b]N\f7\r^5p]N\u0014V-Y2uSZ,\u0017!C5oi\u0016\u0014h.\u00197!\u0003-)gN^5s_:lWM\u001c;\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0006\u0002\u0007\u0015tg/\u0003\u0002-S\t\u00112\t\\;ti\u0016\u0014XI\u001c<je>tW.\u001a8u\u00031)gN^5s_:lWM\u001c;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001GM\u001a\u0011\u0005E\u0002Q\"A\u0005\t\u000bi)\u0001\u0019\u0001\u000f\t\u000b\u0015*\u0001\u0019A\u0014\u0002\u0007I,h\u000eF\u00027\u007f-\u00032a\u000e\u001e=\u001b\u0005A$BA\u001d\u0018\u0003\u0011)H/\u001b7\n\u0005mB$a\u0001+ssB\u0011\u0011'P\u0005\u0003}%\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0011\u0015\u0001e\u00011\u0001B\u0003A!(/\u00198tC\u000e$\u0018n\u001c8M_\u001eL7\r\u0005\u0003\u0017\u0005\u0012;\u0015BA\"\u0018\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00022\u000b&\u0011a)\u0003\u0002\u001a)J\fgn]1di&|g.\u0011;uK6\u0004HoQ8oi\u0016DH\u000fE\u00028u!\u0003\"AF%\n\u0005);\"\u0001B+oSRDq\u0001\u0014\u0004\u0011\u0002\u0003\u0007Q*A\u0004paRLwN\\:\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0011AB2p]\u001aLw-\u0003\u0002S\u001f\n\u0011BK]1og\u0006\u001cG/[8o\u001fB$\u0018n\u001c8t\u00035\u0011XO\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\tQK\u000b\u0002N-.\nq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00039^\t!\"\u00198o_R\fG/[8o\u0013\tq\u0016LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class Transactions {
    private final CoreTransactionsReactive internal;
    private final ClusterEnvironment environment;

    private CoreTransactionsReactive internal() {
        return this.internal;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    public Try<TransactionResult> run(Function1<TransactionAttemptContext, Try<BoxedUnit>> transactionLogic, TransactionOptions options) {
        Scheduler scheduler = this.internal().core().context().environment().transactionsSchedulers().schedulerBlocking();
        Mono x = Mono.defer(() -> {
            CoreMergedTransactionConfig merged = new CoreMergedTransactionConfig(this.internal().config(), Optional.of(options.toCore()));
            CoreTransactionContext overall = new CoreTransactionContext(this.internal().core().context(), UUID.randomUUID().toString(), merged, this.internal().core().transactionsCleanup());
            Mono createAttempt = Mono.defer(() -> {
                String attemptId = UUID.randomUUID().toString();
                CoreTransactionAttemptContext ctx = this.internal().createAttemptContext(overall, merged, attemptId);
                return Mono.just((Object)ctx);
            });
            Function<CoreTransactionAttemptContext, Mono> newTransactionLogic = ctx -> Mono.defer(() -> {
                AsyncTransactionAttemptContext async = new AsyncTransactionAttemptContext((CoreTransactionAttemptContext)ctx, this.environment());
                TransactionAttemptContext ctxBlocking = new TransactionAttemptContext(async);
                return Mono.fromCallable(() -> {
                    Transactions.$anonfun$run$5(ctx, transactionLogic, ctxBlocking);
                    return BoxedUnit.UNIT;
                }).subscribeOn(scheduler).then();
            });
            return this.internal().executeTransaction(createAttempt, merged, overall, newTransactionLogic, false).onErrorResume(err -> ErrorUtil$.MODULE$.convertTransactionFailedInternal((Throwable)err));
        });
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (TransactionResult)x.map((Function)new Function<CoreTransactionResult, TransactionResult>(null){

            public <V> Function<V, TransactionResult> compose(Function<? super V, ? extends CoreTransactionResult> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<CoreTransactionResult, V> andThen(Function<? super TransactionResult, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public TransactionResult apply(CoreTransactionResult result) {
                return TransactionResult$.MODULE$.apply(result);
            }
        }).publishOn(scheduler).block());
    }

    public TransactionOptions run$default$2() {
        return TransactionOptions$.MODULE$.Default();
    }

    public static final /* synthetic */ void $anonfun$run$5(CoreTransactionAttemptContext ctx$1, Function1 transactionLogic$1, TransactionAttemptContext ctxBlocking$1) {
        Success success;
        Try try_;
        TransactionMarkerOwner.set((TransactionMarker)new TransactionMarker(ctx$1));
        Try out = Try$.MODULE$.apply((Function0 & Serializable)() -> (Try)transactionLogic$1.apply((Object)ctxBlocking$1));
        TransactionMarkerOwner.clear();
        Try try_2 = out;
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_2 instanceof Success && (try_ = (Try)(success = (Success)try_2).value()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
    }

    public Transactions(CoreTransactionsReactive internal, ClusterEnvironment environment) {
        this.internal = internal;
        this.environment = environment;
    }
}

