/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.classic.analytics.AnalyticsHelper;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsMetaData;
import com.couchbase.client.scala.analytics.AnalyticsMetrics$;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.analytics.AnalyticsStatus$;
import com.couchbase.client.scala.analytics.AnalyticsWarning;
import com.couchbase.client.scala.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea!\u0002\u0004\b\u0001%\t\u0002\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011B\r\t\u000bu\u0001A\u0011\u0001\u0010\t\u000b\t\u0002A\u0011A\u0012\t\u000b\u0019\u0004A\u0011A4\t\u000ba\u0004A\u0011A=\u0003!\u0005s\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014(B\u0001\u0005\n\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0006\f\u0003\u0015\u00198-\u00197b\u0015\taQ\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001d=\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003A\t1aY8n'\t\u0001!\u0003\u0005\u0002\u0014+5\tACC\u0001\u000b\u0013\t1BC\u0001\u0004B]f\u0014VMZ\u0001\u0003QB\u001c\u0001\u0001\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\t\u0011\u0002*\u00198eY\u0016\u0014()Y:jGB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011a\u0002\u0005\u0006/\t\u0001\r!G\u0001\be\u0016\fX/Z:u+\t!S\fF\u0004&k\tKeJV.\u0011\u0007\u0019J3&D\u0001(\u0015\tAC#\u0001\u0003vi&d\u0017B\u0001\u0016(\u0005\r!&/\u001f\t\u0003YMj\u0011!\f\u0006\u0003]=\n\u0011\"\u00198bYf$\u0018nY:\u000b\u0005A\n\u0014aA7tO*\u0011!gC\u0001\u0005G>\u0014X-\u0003\u00025[\t\u0001\u0012I\\1msRL7m\u001d*fcV,7\u000f\u001e\u0005\u0006m\r\u0001\raN\u0001\ngR\fG/Z7f]R\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e\u0015\u001b\u0005Y$B\u0001\u001f\u0019\u0003\u0019a$o\\8u}%\u0011a\bF\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?)!)1i\u0001a\u0001\t\u00069q\u000e\u001d;j_:\u001c\bCA#H\u001b\u00051%B\u0001\u0018\n\u0013\tAeI\u0001\tB]\u0006d\u0017\u0010^5dg>\u0003H/[8og\")!g\u0001a\u0001\u0015B\u00111\nT\u0007\u0002c%\u0011Q*\r\u0002\u0005\u0007>\u0014X\rC\u0003P\u0007\u0001\u0007\u0001+A\u0006f]ZL'o\u001c8nK:$\bCA)U\u001b\u0005\u0011&BA*\n\u0003\r)gN^\u0005\u0003+J\u0013!c\u00117vgR,'/\u00128wSJ|g.\\3oi\")qk\u0001a\u00011\u00061!-^2lKR\u00042aE-8\u0013\tQFC\u0001\u0004PaRLwN\u001c\u0005\u00069\u000e\u0001\r\u0001W\u0001\u0006g\u000e|\u0007/\u001a\u0003\u0006=\u000e\u0011\ra\u0018\u0002\u0002)F\u0011\u0001m\u0019\t\u0003'\u0005L!A\u0019\u000b\u0003\u000f9{G\u000f[5oOB\u00111\u0003Z\u0005\u0003KR\u00111!\u00118z\u0003)\tX/\u001a:z\u0003NLhn\u0019\u000b\u0003Q^$\"!\u001b:\u0011\u0007)lw.D\u0001l\u0015\taG#\u0001\u0006d_:\u001cWO\u001d:f]RL!A\\6\u0003\r\u0019+H/\u001e:f!\t)\u0005/\u0003\u0002r\r\ny\u0011I\\1msRL7m\u001d*fgVdG\u000fC\u0003t\t\u0001\u000fA/\u0001\u0002fGB\u0011!.^\u0005\u0003m.\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b\t\"\u0001\u0019A\u0016\u0002\u001bE,XM]=SK\u0006\u001cG/\u001b<f)\rQ\u0018q\u0002\t\u0006w\u0006\u0015\u0011\u0011B\u0007\u0002y*\u0011QP`\u0001\naV\u0014G.[:iKJT!AC@\u000b\u0007I\n\tA\u0003\u0002\u0002\u0004\u00059!/Z1di>\u0014\u0018bAA\u0004y\n)1+T8o_B\u0019Q)a\u0003\n\u0007\u00055aIA\fSK\u0006\u001cG/\u001b<f\u0003:\fG.\u001f;jGN\u0014Vm];mi\")!%\u0002a\u0001W\u0001")
public class AnalyticsHandler {
    private final HandlerBasicParams hp;

    public <T> Try<AnalyticsRequest> request(String statement, AnalyticsOptions options, Core core, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable)x$9 -> {
            String string = x$9;
            return Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable)x$8 -> {
                Object object = x$8;
                return Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable)x$7 -> {
                    Object object = x$7;
                    return Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable)x$6 -> {
                        Object object = x$6;
                        return Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable)x$5 -> {
                            Object object = x$5;
                            return Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable)x$4 -> {
                                Object object = x$4;
                                return Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.priority()), "priority").flatMap((Function1 & Serializable)x$3 -> {
                                    Object object = x$3;
                                    return Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable)x$2 -> {
                                        Object object = x$2;
                                        return Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable)x$1 -> {
                                            Object object = x$1;
                                            return null;
                                        });
                                    });
                                });
                            });
                        });
                    });
                });
            });
        });
        if (validations.isFailure()) {
            return validations;
        }
        JsonObject params = options.encode();
        params.put("statement", statement);
        Object object = bucket.isDefined() && scope.isDefined() ? params.put("query_context", AnalyticsRequest.queryContext((String)((String)bucket.get()), (String)((String)scope.get()))) : BoxedUnit.UNIT;
        return Try$.MODULE$.apply((Function0 & Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable)queryStr -> {
            byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
            Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().analyticsTimeout()));
            RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> environment.retryStrategy());
            return new AnalyticsRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, core.context().authenticator(), queryBytes, options.priority() ? -1 : 0, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), params.str("client_context_id"), statement, $this.hp.tracer().requestSpan("analytics", (RequestSpan)options.parentSpan().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)bucket.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)scope.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true, options._endpointIdx());
        });
    }

    public Future<AnalyticsResult> queryAsync(AnalyticsRequest request, ExecutionContext ec) {
        SMono sMono = FutureConversions$.MODULE$.javaMonoToScalaMono(AnalyticsHelper.requireCouchbaseServer((Core)this.hp.core(), (java.time.Duration)request.timeout()));
        this.hp.core().send((Request)request);
        Future ret = sMono.then(FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable)response -> FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows()).collectSeq().flatMap((Function1 & Serializable)rows -> FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable)trailer -> {
            Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(trailer.warnings())).map((Function1 & Serializable)warnings -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala().map((Function1 & Serializable)codeAndMessage -> new AnalyticsWarning((ErrorCodeAndMessage)codeAndMessage))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
            return new AnalyticsResult((scala.collection.immutable.Seq<AnalyticsChunkRow>)rows, new AnalyticsMetaData(response.header().requestId(), response.header().clientContextId().orElse(""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), AnalyticsMetrics$.MODULE$.fromBytes(trailer.metrics()), (Seq<AnalyticsWarning>)warnings2, AnalyticsStatus$.MODULE$.from(trailer.status())));
        })))).toFuture();
        ret.onComplete((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                return request.context().logicallyComplete();
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return request.context().logicallyComplete(err);
            }
            throw new MatchError((Object)try_);
        }, ec);
        return ret;
    }

    public SMono<ReactiveAnalyticsResult> queryReactive(AnalyticsRequest request) {
        return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            SMono sMono = FutureConversions$.MODULE$.javaMonoToScalaMono(AnalyticsHelper.requireCouchbaseServer((Core)$this.hp.core(), (java.time.Duration)request.timeout()));
            $this.hp.core().send((Request)request);
            return sMono.then(FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), false).map((Function1 & Serializable)response -> {
                SMono meta = FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable)trailer -> {
                    Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(trailer.warnings())).map((Function1 & Serializable)warnings -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala().map((Function1 & Serializable)codeAndMessage -> new AnalyticsWarning((ErrorCodeAndMessage)codeAndMessage))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                    return new AnalyticsMetaData(response.header().requestId(), response.header().clientContextId().orElse(""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), AnalyticsMetrics$.MODULE$.fromBytes(trailer.metrics()), (Seq<AnalyticsWarning>)warnings2, AnalyticsStatus$.MODULE$.from(trailer.status()));
                }).doOnNext((Function1 & Serializable)x$10 -> {
                    AnalyticsHandler.$anonfun$queryReactive$7(request, x$10);
                    return BoxedUnit.UNIT;
                }).doOnError((Function1 & Serializable)err -> {
                    AnalyticsHandler.$anonfun$queryReactive$8(request, err);
                    return BoxedUnit.UNIT;
                });
                SFlux rows = FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows());
                return new ReactiveAnalyticsResult(rows, (SMono<AnalyticsMetaData>)meta);
            }));
        });
    }

    public static final /* synthetic */ void $anonfun$queryReactive$7(AnalyticsRequest request$2, AnalyticsMetaData x$10) {
        request$2.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$queryReactive$8(AnalyticsRequest request$2, Throwable err) {
        request$2.context().logicallyComplete(err);
    }

    public AnalyticsHandler(HandlerBasicParams hp) {
        this.hp = hp;
    }
}

