/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.scala.ReactiveCollection;
import com.couchbase.client.scala.ReactiveScope;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.transactions.TransactionGetResult;
import com.couchbase.client.scala.transactions.TransactionGetResult$;
import com.couchbase.client.scala.transactions.TransactionQueryOptions;
import com.couchbase.client.scala.transactions.TransactionQueryResult;
import com.couchbase.client.scala.transactions.TransactionQueryResult$;
import com.couchbase.client.scala.transactions.internal.EncodingUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\u0007\u000f\u0001eA\u0011b\b\u0001\u0003\u0006\u0004%\tA\u0005\u0011\t\u0011%\u0002!\u0011!Q\u0001\n\u0005BaA\u000b\u0001\u0005\u0002AY\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B)\u0001\t\u0003\u0011\u0006\"B+\u0001\t\u00031\u0006\"\u00029\u0001\t\u0003\t\b\"B>\u0001\t\u0003a\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u000b\u0001A\u0011AA\u000b\u0011\u001d\t)\u0001\u0001C\u0001\u0003GAq!!\u0002\u0001\t\u0003\t\tDA\u0011SK\u0006\u001cG/\u001b<f)J\fgn]1di&|g.\u0011;uK6\u0004HoQ8oi\u0016DHO\u0003\u0002\u0010!\u0005aAO]1og\u0006\u001cG/[8og*\u0011\u0011CE\u0001\u0006g\u000e\fG.\u0019\u0006\u0003'Q\taa\u00197jK:$(BA\u000b\u0017\u0003%\u0019w.^2iE\u0006\u001cXMC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c;5\tADC\u0001\u0012\u0013\tqBD\u0001\u0004B]f\u0014VMZ\u0001\tS:$XM\u001d8bYV\t\u0011\u0005\u0005\u0002#O5\t1E\u0003\u0002%K\u0005YAO]1og\u0006\u001cG/[8o\u0015\t1##\u0001\u0003d_J,\u0017B\u0001\u0015$\u0005u\u0019uN]3Ue\u0006t7/Y2uS>t\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018!C5oi\u0016\u0014h.\u00197!\u0003\u0019a\u0014N\\5u}Q\u0011AF\f\t\u0003[\u0001i\u0011A\u0004\u0005\u0006?\r\u0001\r!I\u0001\u0004O\u0016$HcA\u0019?\tB\u0019!'O\u001e\u000e\u0003MR!\u0001N\u001b\u0002\u0013A,(\r\\5tQ\u0016\u0014(BA\t7\u0015\t1sGC\u00019\u0003\u001d\u0011X-Y2u_JL!AO\u001a\u0003\u000bMkuN\\8\u0011\u00055b\u0014BA\u001f\u000f\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8HKR\u0014Vm];mi\")q\b\u0002a\u0001\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005\u0005\u0013U\"\u0001\t\n\u0005\r\u0003\"A\u0005*fC\u000e$\u0018N^3D_2dWm\u0019;j_:DQ!\u0012\u0003A\u0002\u0019\u000b!!\u001b3\u0011\u0005\u001dseB\u0001%M!\tIE$D\u0001K\u0015\tY\u0005$\u0001\u0004=e>|GOP\u0005\u0003\u001br\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Q\nH\u0001#O\u0016$(+\u001a9mS\u000e\fgI]8n!J,g-\u001a:sK\u0012\u001cVM\u001d<fe\u001e\u0013x.\u001e9\u0015\u0007E\u001aF\u000bC\u0003@\u000b\u0001\u0007\u0001\tC\u0003F\u000b\u0001\u0007a)\u0001\u0004j]N,'\u000f^\u000b\u0003/\u000e$B\u0001\u00177n]R\u0011\u0011'\u0017\u0005\u00065\u001a\u0001\u001daW\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bc\u0001/`C6\tQL\u0003\u0002_!\u0005)1m\u001c3fG&\u0011\u0001-\u0018\u0002\u000f\u0015N|gnU3sS\u0006d\u0017N_3s!\t\u00117\r\u0004\u0001\u0005\u000b\u00114!\u0019A3\u0003\u0003Q\u000b\"AZ5\u0011\u0005m9\u0017B\u00015\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00076\n\u0005-d\"aA!os\")qH\u0002a\u0001\u0001\")QI\u0002a\u0001\r\")qN\u0002a\u0001C\u000691m\u001c8uK:$\u0018a\u0002:fa2\f7-Z\u000b\u0003e^$2a\u001d={)\t\tD\u000fC\u0003[\u000f\u0001\u000fQ\u000fE\u0002]?Z\u0004\"AY<\u0005\u000b\u0011<!\u0019A3\t\u000be<\u0001\u0019A\u001e\u0002\u0007\u0011|7\rC\u0003p\u000f\u0001\u0007a/\u0001\u0004sK6|g/\u001a\u000b\u0004{\u0006\r\u0001c\u0001\u001a:}B\u00111d`\u0005\u0004\u0003\u0003a\"\u0001B+oSRDQ!\u001f\u0005A\u0002m\nQ!];fef$B!!\u0003\u0002\u0012A!!'OA\u0006!\ri\u0013QB\u0005\u0004\u0003\u001fq!A\u0006+sC:\u001c\u0018m\u0019;j_:\fV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\r\u0005M\u0011\u00021\u0001G\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0006\u0004\u0002\n\u0005]\u0011\u0011\u0004\u0005\u0007\u0003'Q\u0001\u0019\u0001$\t\u000f\u0005m!\u00021\u0001\u0002\u001e\u00059q\u000e\u001d;j_:\u001c\bcA\u0017\u0002 %\u0019\u0011\u0011\u0005\b\u0003/Q\u0013\u0018M\\:bGRLwN\\)vKJLx\n\u001d;j_:\u001cHCBA\u0005\u0003K\ty\u0003C\u0004\u0002(-\u0001\r!!\u000b\u0002\u000bM\u001cw\u000e]3\u0011\u0007\u0005\u000bY#C\u0002\u0002.A\u0011QBU3bGRLg/Z*d_B,\u0007BBA\n\u0017\u0001\u0007a\t\u0006\u0005\u0002\n\u0005M\u0012QGA\u001c\u0011\u001d\t9\u0003\u0004a\u0001\u0003SAa!a\u0005\r\u0001\u00041\u0005bBA\u000e\u0019\u0001\u0007\u0011Q\u0004")
public class ReactiveTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;

    public CoreTransactionAttemptContext internal() {
        return this.internal;
    }

    public SMono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().get(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$);
    }

    public SMono<TransactionGetResult> getReplicaFromPreferredServerGroup(ReactiveCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().getReplicaFromPreferredServerGroup(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$);
    }

    public <T> SMono<TransactionGetResult> insert(ReactiveCollection collection, String id, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_insert", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return SMono$.MODULE$.raiseError(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().insert(collection.collectionIdentifier(), id, encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$).doOnError((Function1 & Serializable)x$1 -> {
                span.status(RequestSpan.StatusCode.ERROR);
                return BoxedUnit.UNIT;
            }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> span.end());
        }
        throw new MatchError(try_);
    }

    public <T> SMono<TransactionGetResult> replace(TransactionGetResult doc, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_replace", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return SMono$.MODULE$.raiseError(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().replace(doc.internal(), encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$).doOnError((Function1 & Serializable)x$2 -> {
                span.status(RequestSpan.StatusCode.ERROR);
                return BoxedUnit.UNIT;
            }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> span.end());
        }
        throw new MatchError(try_);
    }

    public SMono<BoxedUnit> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_remove", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().remove(doc.internal(), new SpanWrapper(span))).doOnError((Function1 & Serializable)x$3 -> {
            span.status(RequestSpan.StatusCode.ERROR);
            return BoxedUnit.UNIT;
        }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> span.end()).then();
    }

    public SMono<TransactionQueryResult> query(String statement) {
        return this.query(null, statement, null);
    }

    public SMono<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public SMono<TransactionQueryResult> query(ReactiveScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public SMono<TransactionQueryResult> query(ReactiveScope scope, String statement, TransactionQueryOptions options) {
        CoreQueryOptions opts = (CoreQueryOptions)Option$.MODULE$.apply((Object)options).map((Function1 & Serializable)v -> v.toCore()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), opts, false)).publishOn(this.internal().core().context().environment().transactionsSchedulers().schedulerBlocking()).map((Function1)TransactionQueryResult$.MODULE$);
    }

    public ReactiveTransactionAttemptContext(CoreTransactionAttemptContext internal) {
        this.internal = internal;
    }
}

